{*******************************************************}
{                                                       }
{   Copyright (c) 1995-1996 Classic Software            }
{   All rights reserved                                 }
{                                                       }
{*******************************************************}

unit CSNBProp;

{$B-,P+,W-,X+}

interface

uses
  DsgnIntf, Classes;

type
  TcsActivePageProperty = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TcsPagesProperty = class(TPropertyEditor)
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

  TcsTabFontProperty = class(TFontProperty)
  public
    procedure Edit; override;
  end;

  TSkipDirection = (sdNext, sdPrevious);

  TcsNotebookEditor = class(TDefaultEditor)
  private
    procedure PageSkip(Direction: TSkipDirection);
    procedure EditTabs;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

implementation

uses SysUtils, Forms, Dialogs, Graphics, CSNoteBk, CSNBEdit;

{ TcsActivePageProperty }

function TcsActivePageProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList];
end;

procedure TcsActivePageProperty.GetValues(Proc: TGetStrProc);
var Notebook: TcsNotebook;
    Page: TcsPage;
    I: Integer;
begin
  Notebook := GetComponent(0) as TcsNotebook;
  for I := 0 to Notebook.Pages.Count - 1 do
  begin
    Page := Notebook.Pages.Objects[I] as TcsPage;
    Proc(Page.Caption);
  end;
end;

{ TcsPagesProperty }

function TcsPagesProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

function TcsPagesProperty.GetValue: string;
begin
  FmtStr(Result, '(%s)', [GetPropType^.Name]);
end;

procedure TcsPagesProperty.Edit;
var Dlg: TcsNBEditDlg;
begin
  Dlg := TcsNBEditDlg.Create(Application);
  try
    Dlg.Notebook := GetComponent(0) as TcsNotebook;
    Dlg.ShowModal;
    if Dlg.Modified then Designer.Modified;
  finally
    Dlg.Free;
  end;
end;

{ TcsNotebookEditor }

type
  TVerbList = Array[0..2] of String;
const
  Verbs: TVerbList = ('Next Page', 'Previous Page', 'Edit Tabs...');

procedure TcsNotebookEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0:  PageSkip(sdNext);
    1:  PageSkip(sdPrevious);
    2:  EditTabs;
  end;
end;

function TcsNotebookEditor.GetVerb(Index: Integer): string;
begin
  Result := Verbs[Index];
end;

function TcsNotebookEditor.GetVerbCount: Integer;
begin
  Result := High(Verbs) + 1;
end;

procedure TcsNotebookEditor.PageSkip(Direction: TSkipDirection);
var NewPage: Integer;
begin
  with TcsNotebook(Component) do
  begin
    { start at active page } 
    NewPage := PageIndex;

    { skip to the next visible page in the specified direction }
    repeat
      if (Direction = sdNext) then
        if (NewPage = Pages.Count - 1) then
          NewPage := 0
        else
          Inc(NewPage)
      else
        if (NewPage = 0) then
          NewPage := Pages.Count - 1
        else
          Dec(NewPage);
    until TabPageVisible[NewPage] or (NewPage = PageIndex);

    if NewPage <> PageIndex then
    begin
      PageIndex := NewPage;
      Designer.Modified;
    end;

  end;
end;

procedure TcsNotebookEditor.EditTabs;
var Dlg: TcsNBEditDlg;
begin
  Dlg := TcsNBEditDlg.Create(Application);
  try
    Dlg.Notebook := TcsNotebook(Component);
    Dlg.ShowModal;
    if Dlg.Modified then Designer.Modified;
  finally
    Dlg.Free;
  end;
end;

{ TcsTabFontProperty }

const
{ context id for the Font editor }
  hcDFontEditor = 25000;

procedure TcsTabFontProperty.Edit;
var FontDialog: TFontDialog;
    Notebook: TcsNotebook;
begin
  FontDialog := TFontDialog.Create(Application);
  try
    FontDialog.Font := TFont(GetOrdValue);
    FontDialog.HelpContext := hcDFontEditor;
    { remove Effects check boxes and Color list box from options }
    FontDialog.Options := FontDialog.Options + [fdShowHelp, fdForceFontExist] - [fdEffects];
    Notebook := GetComponent(0) as TcsNotebook;
    if Notebook.SidewaysText then
      FontDialog.Options := FontDialog.Options + [fdTrueTypeOnly];
    if FontDialog.Execute then SetOrdValue(Longint(FontDialog.Font));
  finally
    FontDialog.Free;
  end;
end;

end.
