{*******************************************************}
{                                                       }
{   Copyright (c) 1995-1996 Classic Software            }
{   All rights reserved                                 }
{                                                       }
{*******************************************************}

unit CSNBInfo;

{$B-,P+,W-,X+}

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TcsNBInfoDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    CaptionEdit: TEdit;
    HelpContextEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    EnabledLabel: TLabel;
    EnabledCheck: TCheckBox;
    VisibleLabel: TLabel;
    VisibleCheck: TCheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure EnabledLabelClick(Sender: TObject);
    procedure VisibleLabelClick(Sender: TObject);
  end;

implementation

{$R *.DFM}

uses SysUtils, Dialogs, PicEdit;

procedure TcsNBInfoDlg.OKBtnClick(Sender: TObject);
begin
  try
    StrToInt(HelpContextEdit.Text);
  except
    on EConvertError do
    begin
      ModalResult := mrNone;
      MessageDlg('Help Context is not a valid integer value.', mtError, [mbOK], 0);
      HelpContextEdit.SelectAll;
      HelpContextEdit.SetFocus;
    end;
  end;
end;

procedure TcsNBInfoDlg.EnabledLabelClick(Sender: TObject);
begin
  EnabledCheck.Checked := not EnabledCheck.Checked;
end;

procedure TcsNBInfoDlg.VisibleLabelClick(Sender: TObject);
begin
  VisibleCheck.Checked := not VisibleCheck.Checked;
end;

end.
