{*******************************************************}
{                                                       }
{   Copyright (c) 1996-1997 Classic Software            }
{   All rights reserved                                 }
{                                                       }
{*******************************************************}

unit CSFrmPnl;

{$B-,P+,W-,X+}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  {  To enable resource saving of the panel's handle,
     declare a public DestroyHandle method (static,
     not overridden) in the sub-form's class, and then
     define the DestroyHandle method in the sub-form's
     implementation section like so:

     procedure TSubForm1.DestroyHandle;
     begin
       inherited DestroyHandle;
     end;
  }
  TcsFormPanel = class(TCustomPanel)
  private
    FFormName: String;
    FForm: TForm;
    FOnAfterFormChanged: TNotifyEvent;
    FOnBeforeFormChanged: TNotifyEvent;
    procedure SetForm(Value: TForm);
    procedure SetFormName(Value: String);
  protected
    procedure AfterFormChanged; virtual;
    procedure BeforeFormChanged; virtual;
    procedure Loaded; override;
    procedure Paint; override;
    procedure Resize; override;
  public
    constructor Create(AOwner: TComponent); override;
    property Form: TForm read FForm write SetForm;
  published
    property Align;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property BorderWidth;
    property BorderStyle;
    property Caption;
    property Color;
    property Enabled;
    property FormName: String read FFormName write SetFormName;
    property ParentColor;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnAfterFormChanged: TNotifyEvent
      read FOnAfterFormChanged write FOnAfterFormChanged;
    property OnBeforeFormChanged: TNotifyEvent
      read FOnBeforeFormChanged write FOnBeforeFormChanged;
    property OnEnter;
    property OnExit;
  end;

implementation

{$IFDEF EVALUATION} uses CSEval; {$ENDIF}

{ TcsFormPanel }

constructor TcsFormPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Height := 82;
  FFormName := '';
  FForm := nil;
end;

procedure TcsFormPanel.AfterFormChanged;
begin
  if Assigned(FOnAfterFormChanged) then FOnAfterFormChanged(Self);
end;

procedure TcsFormPanel.BeforeFormChanged;
begin
  if Assigned(FOnBeforeFormChanged) then FOnBeforeFormChanged(Self);
end;

procedure TcsFormPanel.Loaded;
begin
  inherited Loaded;
  { always use a blank caption at run-time }
  if (Caption <> '') and not (csDesigning in ComponentState) then
    Caption := '';
end;

{ The FormName property is only of use when the specified form is
  Auto-created (and thus will be present in Application.Components),
  otherwise a form should be assigned using the Form property.
}
procedure TcsFormPanel.SetFormName(Value: String);
begin
  { Capitalise first letter of form name }
  if Length(Value) > 0 then
    Value := AnsiUpperCase(Copy(Value, 1, 1)) + Copy(Value, 2, Length(Value) - 1);
  if Value <> FFormName then
  begin
    FFormName := Value;
    SetForm(nil);
    Invalidate;
  end;
end;

procedure TcsFormPanel.SetForm(Value: TForm);
begin
  if Value <> FForm then
  begin
    BeforeFormChanged;
    if (FForm <> nil) then { hide current form }
      FForm.Visible := False;
    FForm := Value;
    if (FForm <> nil) then
    begin
      FForm.Parent := Self;
      FForm.BorderIcons := [];
      FForm.BorderStyle := bsNone; { this will change AutoScroll }
      FForm.AutoScroll := True;  { re-assign after changing BorderStyle }
      Resize;
      FForm.Visible := True;
    end;
    AfterFormChanged;
  end;
end;

procedure TcsFormPanel.Paint;
var NewForm: TForm;
    FormClassName: String;
    I: Integer;
begin
  inherited Paint;
  if FForm <> nil then
    { use currently assigned form }
    SetForm(FForm)
  else
  begin
    { attempt to find form using FormName in Application's components }
    NewForm := nil;
    FormClassName := 'T' + AnsiUpperCase(FFormName);
    for I := 0 to Application.ComponentCount - 1 do
      { perform case-insensitive class-name comparison }
      if (AnsiUpperCase(Application.Components[I].ClassName) = FormClassName) then
      begin
        NewForm := TForm(Application.Components[I]);
        Break;
      end;
    SetForm(NewForm);
  end;
end;

procedure TcsFormPanel.Resize;
var Rect: TRect;
begin
  inherited Resize;
  if (FForm <> nil) and not (csDestroying in ComponentState) then
  begin
    Rect := ClientRect;
    AlignControls(FForm, Rect);
    FForm.SetBounds(Rect.Left, Rect.Top, Rect.Right - Rect.Left, Rect.Bottom - Rect.Top);
  end;
end;

end.
