{*******************************************************}
{                                                       }
{   Copyright (c) 1996 Classic Software                 }
{   All rights reserved                                 }
{                                                       }
{*******************************************************}

unit CSADProp;

{$B-,P+,W-,X+}

interface

uses
  DsgnIntf, Classes;

type
  { Component editor for TcsAutoDefaults components. }
  TcsAutoDefaultsEditor = class(TDefaultEditor)
  private
    procedure Edit; override;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  { TcsAutoDefaultsFilenameProperty
    Property editor for the Filename property of TcsAutoDefaults.
    Displays a File Open Dialog for the name of the AutoDefaults file.
  }
  TcsAutoDefaultsFilenameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

implementation

uses Forms, Dialogs, IniFiles, CSADMain, CSADEdit;

{ TcsAutoDefaultsEditor }

type
  TVerbList = Array[0..0] of String;
const
  Verbs: TVerbList = ('Edit...');

procedure TcsAutoDefaultsEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0:  Edit;
  end;
end;

function TcsAutoDefaultsEditor.GetVerb(Index: Integer): string;
begin
  Result := Verbs[Index];
end;

function TcsAutoDefaultsEditor.GetVerbCount: Integer;
begin
  Result := High(Verbs) + 1;
end;

procedure TcsAutoDefaultsEditor.Edit;
var Dlg: TcsAutoDefaultsEditDlg;
begin
  Dlg := TcsAutoDefaultsEditDlg.Create(Application);
  try
    Dlg.DesignForm := Designer.Form;
    Dlg.DefaultsComponent := TcsAutoDefaults(Component);
    Dlg.ShowModal;
    if Dlg.Modified then Designer.Modified;
  finally           
    Dlg.Free;
  end;
end;

{ TcsAutoDefaultsFilenameProperty }

procedure TcsAutoDefaultsFilenameProperty.Edit;
var FileOpen: TOpenDialog;
    IniFile: TIniFile;
    Extension, Mask: String;
begin
  FileOpen := TOpenDialog.Create(Application);
  FileOpen.Filename := GetValue;
  IniFile := TIniFile.Create('delphi.ini');
  try
    Extension := IniFile.ReadString('ClassicSoftware.AutoDefaults',
                                    'Extension', 'adf');
  finally
    IniFile.Free;
  end;
  Mask := '*.' + Extension;
  FileOpen.DefaultExt := Extension;
  FileOpen.Filter :=  'Auto Defaults (' + Mask + ')|' + Mask + '|' +
                      'All Files (*.*)|*.*';
  FileOpen.Options := [ofCreatePrompt, ofHideReadOnly, ofNoReadOnlyReturn,
                        ofPathMustExist];
  try
    if FileOpen.Execute then SetValue(FileOpen.Filename);
  finally
    FileOpen.Free;
  end;
end;

function TcsAutoDefaultsFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

end.
