//  (C) COPYRIGHT International Business Machines Corp. 1996
//  All Rights Reserved
//  Licensed Materials - Property of IBM
//  US Government Users Restricted Rights - Use, duplication or
//  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
//
//  DISCLAIMER OF WARRANTIES.
//  The following [enclosed] code is sample code created by IBM
//  Corporation. This sample code is not part of any standard or IBM
//  product and is provided to you solely for the purpose of assisting
//  you in the development of your applications.  The code is provided
//  "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
//  NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//  FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
//  THIS CODE.  THIS CODE MAY CONTAIN ERRORS.  IBM shall not be liable
//  for any damages arising out of your use of the sample code, even
//  if it has been advised of the possibility of such damages.
//
//  DISTRIBUTION.
//  This sample code can be freely distributed, copied, altered, and
//  incorporated into other software, provided that it bears the above
//  Copyright notice and DISCLAIMER intact.

package COM.ibm.CORBA.iiop.tutorial1.example2;

import java.io.*;
import java.lang.*;
import java.net.*;
import java.util.*;

import COM.ibm.CORBA.iiop.*;
import COM.ibm.CORBA.iiop.iiop.*;

public class Transfer
{
    public static String serverName = null;
    public static String serverPort = null;

    public static void main(String args[])
    {
        switch (args.length) {

        case 4:
            serverName = args[0];
            serverPort = args[1];
            String account = args[2];
                float amount = Float.valueOf(args[3]).floatValue();

            transferFunds(account, amount);
            break;

        default:
            System.err.println("Usage: DoTransfer serverName " +
                   "serverPort accountNameTo transferAmount");
        }
    }

    public static void transferFunds(String account, float amount)
    {
        String hostURL = new String("IIOPID://"+serverName+":"+serverPort);
        Account checking = null;
        Account savings = null;

        Properties initProperties = new Properties();
        initProperties.put("server", serverName);
        initProperties.put("port", String.valueOf(serverPort));
        initProperties.put("count", String.valueOf(1));
        ORB client = (COM.ibm.CORBA.iiop.ORB)ORB.init((java.applet.Applet)null, initProperties);
        checking = (Account)client.URLToObject(hostURL+
            ";/Checking" +
            "?COM.ibm.CORBA.iiop.tutorial1.example2.Account" );
        savings = (Account)client.URLToObject(hostURL+
            ";/Savings" +
            "?COM.ibm.CORBA.iiop.tutorial1.example2.Account" );
        System.out.println("Current checking balance " + checking.getBalance());
        System.out.println("Current savings  balance " + savings.getBalance());
        System.out.print("Transfering " + amount );
        if (account.equals("checking")) {
                System.out.println(" from savings to checking");
                savings.withdrawal(amount);
                checking.deposit(amount);
        } else {
                System.out.println(" from checking to savings");
                checking.withdrawal(amount);
            savings.deposit(amount);
        }
        System.out.println("New checking balance " + checking.getBalance());
        System.out.println("New savings  balance " + savings.getBalance());
        client.disconnect(null);
    }
}




