//  (C) COPYRIGHT International Business Machines Corp. 1996
//  All Rights Reserved
//  Licensed Materials - Property of IBM
//  US Government Users Restricted Rights - Use, duplication or
//  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
//
//  DISCLAIMER OF WARRANTIES.
//  The following [enclosed] code is sample code created by IBM
//  Corporation. This sample code is not part of any standard or IBM
//  product and is provided to you solely for the purpose of assisting
//  you in the development of your applications.  The code is provided
//  "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
//  NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//  FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
//  THIS CODE.  THIS CODE MAY CONTAIN ERRORS.  IBM shall not be liable
//  for any damages arising out of your use of the sample code, even
//  if it has been advised of the possibility of such damages.
//
//  DISTRIBUTION.
//  This sample code can be freely distributed, copied, altered, and
//  incorporated into other software, provided that it bears the above
//  Copyright notice and DISCLAIMER intact.

package COM.ibm.CORBA.iiop.tutorial1.example2;

import java.util.Properties;
import COM.ibm.CORBA.iiop.ORB;



/*
 * This is sample code to demonstrate an ORB init from an application.  This
 * form uses the properties list.
 */
public class AppInitSample2 {

    public static void main(String args[]) {
        String serverName  = args[0];
        String serverPort  = args[1];
        String servletName = args[2];

        Properties props = new Properties();
        props.put("server", serverName);
        props.put("port", String.valueOf(serverPort));
        props.put("servlet", servletName);
        props.put("debug", String.valueOf(false));

        // In this case, args is not examined; only props are used
        ORB client = (COM.ibm.CORBA.iiop.ORB) ORB.init(args, props);

        String hostURL = new String("IIOPID://" + serverName + ":" + serverPort);

        Account checking =
            (Account) client.URLToObject(hostURL + ";/Checking" +
            "?COM.ibm.CORBA.iiop.tutorial1.example2.Account");

        Account savings =
            (Account)client.URLToObject(hostURL + ";/Savings" +
            "?COM.ibm.CORBA.iiop.tutorial1.example2.Account" );

        System.out.println("Current checking balance " +
                           checking.getBalance());
        System.out.println("Current savings  balance " +
                           savings.getBalance());

        float amount = (float) 15.00;
        System.out.println("from savings to checking");
        savings.withdrawal(amount);
        checking.deposit(amount);

        System.out.println("New checking balance " + checking.getBalance());
        System.out.println("New savings  balance " + savings.getBalance());
        client.disconnect(null);
    }
}
