//  (C) COPYRIGHT International Business Machines Corp. 1996
//  All Rights Reserved
//  Licensed Materials - Property of IBM
//  US Government Users Restricted Rights - Use, duplication or
//  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
//
//  DISCLAIMER OF WARRANTIES.
//  The following [enclosed] code is sample code created by IBM
//  Corporation. This sample code is not part of any standard or IBM
//  product and is provided to you solely for the purpose of assisting
//  you in the development of your applications.  The code is provided
//  "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
//  NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//  FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
//  THIS CODE.  THIS CODE MAY CONTAIN ERRORS.  IBM shall not be liable
//  for any damages arising out of your use of the sample code, even
//  if it has been advised of the possibility of such damages.
//
//  DISTRIBUTION.
//  This sample code can be freely distributed, copied, altered, and
//  incorporated into other software, provided that it bears the above
//  Copyright notice and DISCLAIMER intact.

package COM.ibm.CORBA.iiop.tutorial1.example2;

import java.applet.Applet;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;
import COM.ibm.CORBA.iiop.ORB;


public class AccountsUI extends java.applet.Applet
{
    // Fields that change between tutorials will be listed here.
    protected ORB orb = null;

    // Business objects.
    protected Account checkingAccount = null;
    protected Account savingsAccount = null;

    // User interface fields
    protected final String kTitleLabel = "Account Update Applet";
    protected final String kAccountLabel = "Account: ";
    protected final String kChecking = "Checking";
    protected final String kSavings = "Savings";
    protected final String kUpdate = "Update: ";
    protected final String kWithdrawal = "Withdrawal";
    protected final String kDeposit = "Deposit";
    protected final String kAmountLabel = "Amount: ";
    protected final String kAmountDefault = "5.00";
    protected final String kUpdateLabel = "Perform update";
    protected final String kUpdateRequested =
    "Update requested (this may take a moment)...";
    protected final String kUpdateInstructions =
    "Make changes, then click the \"" + kUpdateLabel + "\" button...";
    protected Choice accountType = null;
    protected Choice updateType = null;
    protected TextField amount = null;
    protected Button updateButton = null;
    protected TextArea statusTextArea = null;


    // This main() allows this code to serve as both an applet as well as
    // an application.
    public static void
    main(String args[])
    {
        AccountsUI accountsUI = new AccountsUI();

        Frame browserStubFrame = new Frame("Account Update");
        browserStubFrame.add("Center", accountsUI);
        browserStubFrame.resize(550, 300);

        accountsUI.init();

        browserStubFrame.show();
    }


    public void
    init()
    {
        resolveAndActivateAccounts();
        buildUserInterface();
    }


    // Throughout the tutorial, the way the accounts are created or
    // activated, will vary, however, this method will always contain the
    // mechanism for obtaining these objects.
    public void
    resolveAndActivateAccounts()
    {
        Properties initProperties = new Properties();
        String serverName = new String(getParameter("serverName"));
        String serverPort = new String(getParameter("serverPort"));
        initProperties.put("server", serverName);
        initProperties.put("port", String.valueOf(serverPort));
        initProperties.put("servlet", "");
        orb = (COM.ibm.CORBA.iiop.ORB)ORB.init((java.applet.Applet)null,
                                         initProperties);

        // Activate the accounts using "resolve"
        checkingAccount =
            (Account)
            orb.URLToObject(getParameter("URLToObjectContext") +
                            ";/Checking" +
                            "?COM.ibm.CORBA.iiop.tutorial1.example2.Account");

        savingsAccount =
            (Account)
            orb.URLToObject(getParameter("URLToObjectContext") +
                            ";/Savings" +
                            "?COM.ibm.CORBA.iiop.tutorial1.example2.Account");
    }


    protected void
    buildUserInterface()
    {
        setFont(new Font("TimesRoman", Font.PLAIN, 12));

        Panel topHalfPanel = new Panel();
        topHalfPanel.setLayout(new GridLayout(3, 1, 0, 0));
        add(topHalfPanel);


        // Create a panel so the update type and the amount can be
        // layed out via the grid layout scheme vertically.
        Panel accountTypePanel = new Panel();
        accountTypePanel.setLayout(new GridLayout(1, 2, 0, 0));
        topHalfPanel.add(accountTypePanel);

        Panel accountTypeLeftPanel = new Panel();
        accountTypeLeftPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        accountTypePanel.add(accountTypeLeftPanel);

        Panel accountTypeRightPanel = new Panel();
        accountTypeRightPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
        accountTypePanel.add(accountTypeRightPanel);

        Label accountTypeLabel = new Label(kAccountLabel, Label.RIGHT);
        accountTypeLabel.setFont(new Font("TimesRoman", Font.BOLD, 14));
        accountTypeLeftPanel.add(accountTypeLabel);

        accountType = new Choice();
        accountType.addItem(kChecking);
        accountType.addItem(kSavings);
        accountType.setBackground(Color.white);
        accountType.setForeground(Color.black);
        accountTypeRightPanel.add(accountType);

        accountType.select(kChecking);


        // Create a panel so the update type and the amount can be
        // layed out via the grid layout scheme vertically.
        Panel updateTypePanel = new Panel();
        updateTypePanel.setLayout(new GridLayout(1, 2, 0, 0));
        topHalfPanel.add(updateTypePanel);

        Panel updateTypeLeftPanel = new Panel();
        updateTypeLeftPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        updateTypePanel.add(updateTypeLeftPanel);

        Panel updateTypeRightPanel = new Panel();
        updateTypeRightPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
        updateTypePanel.add(updateTypeRightPanel);

        Label updateTypeLabel = new Label(kUpdate, Label.RIGHT);
        updateTypeLabel.setFont(new Font("TimesRoman", Font.BOLD, 14));
        updateTypeLeftPanel.add(updateTypeLabel);

        updateType = new Choice();
        updateType.addItem(kWithdrawal);
        updateType.addItem(kDeposit);
        updateType.setBackground(Color.white);
        updateType.setForeground(Color.black);
        updateTypeRightPanel.add(updateType);

        updateType.select(kDeposit);

        // Create the amount panels.
        Panel amountPanel = new Panel();
        amountPanel.setLayout(new GridLayout(1, 2, 1, 1));
        topHalfPanel.add(amountPanel);

        Panel amountLeftPanel = new Panel();
        amountLeftPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        amountPanel.add(amountLeftPanel);

        Panel amountRightPanel = new Panel();
        amountRightPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
        amountPanel.add(amountRightPanel);

        // Add the amount label to the left panel.
        Label amountLabel = new Label(kAmountLabel, Label.RIGHT);
        amountLabel.setFont(new Font("TimesRoman", Font.BOLD, 14));
        amountLeftPanel.add(amountLabel);

        // Add the amount text area to the right panel.
        amount = new TextField(kAmountDefault, 7);
        amountRightPanel.add(amount);

        // Create the panel for the status label.
        Panel statusPanel = new Panel();
        statusPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        add(statusPanel);

        // Create the status label.
        statusTextArea = new TextArea(kUpdateInstructions, 4, 60);
        statusTextArea.setBackground(Color.white);
        statusTextArea.setForeground(Color.black);
        statusTextArea.setEditable(false);
        statusPanel.add(statusTextArea);

        // Create the panel for the update button.
        Panel updatePanel = new Panel();
        add(updatePanel);

        // Create the update button.
        updateButton = new Button(kUpdateLabel);
        updateButton.setFont(new Font("TimesRoman", Font.BOLD, 14));
        updatePanel.add(updateButton);
    }


    public boolean
    action(Event event,
           Object object)
    {
        // Execute update if the update button was pressed.
        if (event.target instanceof Button &&
            ((String) object).equals(kUpdateLabel)) {
            updateButtonCallback();
        }

        return true;
    }


    public void
    destroy()
    {
        orb.disconnect(null);
    }


    //-------------------------------------------------------------------------
    // Protected methods


    protected void
    updateButtonCallback()
    {
        try {
            // Tell the user via the UI that we are working on the update.
            statusTextArea.replaceText(kUpdateRequested, 0, 1000);


            float adjustedBalance = 0;


            // Do the deposit/withdrawal on the appropriate account, then
            // get the new account balance.
            if (accountType.getSelectedItem().equals(kChecking)) {

                if (updateType.getSelectedItem().equals(kWithdrawal)) {
                    checkingAccount.withdrawal
                        (Float.valueOf(amount.getText()).floatValue());
                }
                else {
                    checkingAccount.deposit
                        (Float.valueOf(amount.getText()).floatValue());
                }

                // Get the new balance.
                adjustedBalance = checkingAccount.getBalance();

                // Update the user interface.
                statusTextArea.replaceText("Adjusted checking balance: " +
                                       adjustedBalance, 0, 1000);
           }
            else {
                if (updateType.getSelectedItem().equals(kWithdrawal)) {
                    savingsAccount.withdrawal
                        (Float.valueOf(amount.getText()).floatValue());
                }
                else {
                    savingsAccount.deposit
                        (Float.valueOf(amount.getText()).floatValue());
                }

                // Get the new balance.
                adjustedBalance = savingsAccount.getBalance();

                // Update the user interface.
                statusTextArea.replaceText("Adjusted savings balance: " +
                                       adjustedBalance, 0, 1000);
            }

            statusTextArea.appendText("\n\n" + kUpdateInstructions);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
