//  (C) COPYRIGHT International Business Machines Corp. 1996
//  All Rights Reserved
//  Licensed Materials - Property of IBM
//  US Government Users Restricted Rights - Use, duplication or
//  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
//
//  DISCLAIMER OF WARRANTIES.
//  The following [enclosed] code is sample code created by IBM
//  Corporation. This sample code is not part of any standard or IBM
//  product and is provided to you solely for the purpose of assisting
//  you in the development of your applications.  The code is provided
//  "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
//  NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//  FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
//  THIS CODE.  THIS CODE MAY CONTAIN ERRORS.  IBM shall not be liable
//  for any damages arising out of your use of the sample code, even
//  if it has been advised of the possibility of such damages.
//
//  DISTRIBUTION.
//  This sample code can be freely distributed, copied, altered, and
//  incorporated into other software, provided that it bears the above
//  Copyright notice and DISCLAIMER intact.

package COM.ibm.CORBA.iiop.tutorial1.example2;


import COM.ibm.CORBA.iiop.*;


public class AccountStub
       extends COM.ibm.CORBA.iiop.iiop.Stub
       implements Account
{
    public
    AccountStub()
    {
    }


    public synchronized float 
    balance()
    {
        try {
            // Get a new request stream
            COM.omg.CORBA.portable.OutputStream request =
                newRequest("balance");

            // Send the request and wait for a reply
            COM.omg.CORBA.portable.InputStream reply =
                sendRequest(request);

            // Unmarshall the return value
            return (float) ((COM.ibm.CORBA.iiop.iiop.MarshalInputStream)reply).read_float();

        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error in remote method call.");
        }
    }


    public synchronized void 
    balance(float parm1)
    {
        try {
            // Get a new request stream
            COM.omg.CORBA.portable.OutputStream request =
                newRequest("balanceF");

            // Marshall the parameters
           request.write_float(parm1);

            // Send the request and wait for a reply
            COM.omg.CORBA.portable.InputStream reply =
                sendRequest(request);


        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error in remote method call.");
        }
    }


    public synchronized void 
    deposit(float parm1)
    {
        try {
            // Get a new request stream
            COM.omg.CORBA.portable.OutputStream request =
                newRequest("deposit");

            // Marshall the parameters
           request.write_float(parm1);

            // Send the request and wait for a reply
            COM.omg.CORBA.portable.InputStream reply =
                sendRequest(request);


        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error in remote method call.");
        }
    }


    public synchronized void 
    withdrawal(float parm1)
    {
        try {
            // Get a new request stream
            COM.omg.CORBA.portable.OutputStream request =
                newRequest("withdrawal");

            // Marshall the parameters
           request.write_float(parm1);

            // Send the request and wait for a reply
            COM.omg.CORBA.portable.InputStream reply =
                sendRequest(request);


        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error in remote method call.");
        }
    }


    public synchronized float 
    getBalance()
    {
        try {
            // Get a new request stream
            COM.omg.CORBA.portable.OutputStream request =
                newRequest("getBalance");

            // Send the request and wait for a reply
            COM.omg.CORBA.portable.InputStream reply =
                sendRequest(request);

            // Unmarshall the return value
            return (float) ((COM.ibm.CORBA.iiop.iiop.MarshalInputStream)reply).read_float();

        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error in remote method call.");
        }
    }
}
