//  (C) COPYRIGHT International Business Machines Corp. 1996
//  All Rights Reserved
//  Licensed Materials - Property of IBM
//  US Government Users Restricted Rights - Use, duplication or
//  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
//
//  DISCLAIMER OF WARRANTIES.
//  The following [enclosed] code is sample code created by IBM
//  Corporation. This sample code is not part of any standard or IBM
//  product and is provided to you solely for the purpose of assisting
//  you in the development of your applications.  The code is provided
//  "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
//  NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//  FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
//  THIS CODE.  THIS CODE MAY CONTAIN ERRORS.  IBM shall not be liable
//  for any damages arising out of your use of the sample code, even
//  if it has been advised of the possibility of such damages.
//
//  DISTRIBUTION.
//  This sample code can be freely distributed, copied, altered, and
//  incorporated into other software, provided that it bears the above
//  Copyright notice and DISCLAIMER intact.

package COM.ibm.CORBA.iiop.tutorial1.example2;


import COM.ibm.CORBA.iiop.*;


public class AccountSkeleton
       extends COM.ibm.CORBA.iiop.iiop.Skeleton
{
    public
    AccountSkeleton()
    {
    }


    public void
    processRequest(java.lang.Object targetIn,
                   String methodName,
                   COM.omg.CORBA.portable.InputStream request,
                   COM.omg.CORBA.portable.OutputStream reply)
    {
        try {
            Account target = (Account) targetIn;

            if (methodName.equals("balance")) {
                // Call the method and unmarshall the parameters
                float result =
                target.balance();
                reply.write_float(result);
            }
            else
            if (methodName.equals("balanceF")) {
                // Call the method and unmarshall the parameters
                target.balance(((float) request.read_float()));
            }
            else
            if (methodName.equals("deposit")) {
                // Call the method and unmarshall the parameters
                target.deposit(((float) request.read_float()));
            }
            else
            if (methodName.equals("withdrawal")) {
                // Call the method and unmarshall the parameters
                target.withdrawal(((float) request.read_float()));
            }
            else
            if (methodName.equals("getBalance")) {
                // Call the method and unmarshall the parameters
                float result =
                target.getBalance();
                reply.write_float(result);
            }
            else
                throw new RuntimeException("Method not recognized");

        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception in skeleton");
        }
    }
}
