set sitename "My Site Name"

# The name of the site for command purposes (all lowercase)
set sitecmd "MSN"

# This flag tells dirlog whether or not to cycle. Leave it at 1 if
# you don't know what I mean.
set dirlog_recycle 1

# This is a variable that you shouldnt change.
# (Internal variable.  Don't reset it if script is already loaded)
if {![info exists dirlog_mrd]} {
  set dirlog_mrd ""
}


# These are the channels that the bot broadcasts to
# whenever there is a new dir.
set dirlog_brchans {
  #YourChannelName
}

# This is the interval in seconds for which dirchecking occurs
set check_interval 10

# If toolbox is not loaded for some reason, then we just load the utimerexists
# proc from it.  utimerexists proc written by cmw, full credit to him.

if {![info exists toolbox_loaded]} {
  # check to see if a utimer for a certain procedure exists
  # cmwagner@sodre.net
     proc utimerexists {timer_proc} {
        foreach j [utimers] {
           if {[string compare [lindex $j 1] $timer_proc] == 0} {
                return [lindex $j 2]
           }
        }
     }
}

if {[utimerexists check_dirlog] == ""} {
  utimer $check_interval "check_dirlog"
}

proc killalltimers {} { foreach ut [utimers] { killutimer [lindex $ut 2] } }

proc check_dirlog {} {
  global dirlog_recycle dirlog_mrd dirlog_brchans sitename check_interval
  set q [lindex [get_recent 1] 0] ; set p [lindex $q 4] ; set u [lindex $q 2]
  set g [lindex $q 3]

  if { $p != ""} {
  	if { $p != $dirlog_mrd } {
		foreach chan $dirlog_brchans {
			putserv "PRIVMSG $chan :\[rFtpd\] \002$sitename\002 \002(\002$u - $g\002)\002 $p"
		}
  		set dirlog_mrd $p
  	}
  }
  if { $dirlog_recycle } { utimer $check_interval "check_dirlog" }

}

proc get_recent { num } {
set fd [open "|/rftpd/bin/rftpdnew $num"]
set i 1
while { $i <= $num } {
        lappend unf [gets $fd]
	incr i
}
close $fd
return $unf

}

bind pub - !thnew pub_new

proc pub_new { nick uhost hand chan args } {
global sitename sitecmd
set num [lindex $args 0]
    if { $num < 100 } {
    putserv "NOTICE $nick :Most recent $num directories on \002$sitename\002 :"
    set i 1
    foreach dir [get_recent $num] {
      set path [lindex $dir 4] ; set upper [lindex $dir 2]
	set g [lindex $dir 3]; set age0 [lindex $dir 0]; set age1 [lindex $dir 1]
	putserv "NOTICE $nick : ${i} $dir"
      incr i
    }
  }
}


bind pub - !thweektop pub_weektop

proc pub_weektop { nick uhost hand chan args } {
	global sitename sitecmd
	set fd [open "|/rftpd/bin/wktop"]
	gets $fd line
	set end [eof $fd]
	while { $end != 1 } {
		putserv "NOTICE $nick : $line "
		gets $fd line
		set end [eof $fd]
	}
	close $fd
}

bind pub - !thnukes pub_nukes

proc pub_nukes { nick uhost hand chan args } {
	global sitename sitecmd
	set fd [open "|/rftpd/bin/rftpdnukes 10"]
	gets $fd line
	set end [eof $fd]
	while { $end != 1 } {
		putserv "NOTICE $nick : $line "
		gets $fd line
		set end [eof $fd]
	}
	close $fd
}

bind pub - !thsearch pub_search

proc pub_search { nick uhost hand chan args } {
	global sitename sitecmd
	set pat [lindex $args 0]
	set num 10
	set fd [open "|/rftpd/bin/rftpdsearch $num $pat"]
	gets $fd line
	set end [eof $fd]
	while { $end != 1 } {
		putserv "NOTICE $nick : $line "
		gets $fd line
		set end [eof $fd]
	}
	close $fd
}


putlog "rftpd.tcl loaded"

set rftpd_loaded 1

