//--------- system-depending:
  /* is _dos_setftime and _dos_setfileattr available? yes -> declare DOS! */
//#define DOS


#include <signal.h>
#include <io.h>
#include <dirent.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>

#include "declare.h"
#include "acestruc.h"

//--------- buffers: increase sizes when possible to speed up the program
#define size_rdb 1024 //1024
#define size_wrb 2048 //4096
#define size_buf 1024

ULONG buf_rd[size_rdb];
CHAR buf[size_buf];
CHAR buf_wr[size_wrb];

//--------- (de-)compressor constants
#define maxdic 22
#define maxwd_mn 11
#define maxwd_lg 11
#define maxwd_svwd 7
#define maxlen 259
#define maxdis2 255
#define maxdis3 8191
#define maxcode (255+4+maxdic)
#define svwd_cnt 15
#define max_cd_mn (256+4+(maxdic+1)-1)
#define max_cd_lg (256-1)

//--------- decompressor variables
SHORT rpos,dcpr_do,dcpr_do_max,blocksize,dcpr_dic,dcpr_frst_file;
SHORT dcpr_oldnum,bits_rd,dcpr_frst_file;
USHORT dcpr_code_mn[1<<maxwd_mn],dcpr_code_lg[1<<maxwd_lg];
UCHAR dcpr_wd_mn[maxcode+2],dcpr_wd_lg[maxcode+2],wd_svwd[svwd_cnt];
ULONG dcpr_dpos,cpr_dpos2,dcpr_dicsiz,dcpr_dican,
      dcpr_size,
      dcpr_olddist[4],
      code_rd;

CHAR *dcpr_text;

//--------- quicksort
#define xchg_def(v1,v2) {INT dummy;\
                         dummy=v1; \
                         v1=v2;    \
                         v2=dummy;}

USHORT sort_org[maxcode+2];
UCHAR sort_freq[(maxcode+2)*2];

//--------- file handling
CHAR aname[PATH_MAX];
INT archan,wrhan;
LONG skipsize;

//--------- structures for archive handling
thead head;

typedef struct _dos_ftime
{
  UINT sec:5;
  UINT min:6;
  UINT hour:5;
  UINT day:5;
  UINT month:4;
  UINT year:7;
} dos_ftime;

struct tadat
{
  INT sol,vol,vol_num;
  dos_ftime time_cr;
} adat;

//--------- system things
#define flush fflush(stdout);

#define in(v1,v2,v3) ((((long)v1)>=(v2)) && (((long)v1)<=(v3)))
#define upcase(ch) ((in(ch,'a','z'))?(ch-32):(ch))

#define delay_len 500

//--------- flags
INT f_err,f_ovrall,f_allvol_pr,f_curpas,f_criterr;

#define ERR_MEM 1
#define ERR_FILES 2
#define ERR_FOUND 3
#define ERR_FULL 4
#define ERR_OPEN 5
#define ERR_READ 6
#define ERR_WRITE 7
#define ERR_CLINE 8
#define ERR_CRC 9
#define ERR_OTHER 10
#define ERR_USER 255

//-------- CRC
#define CRC_MASK        0xFFFFFFFFL
#define CRCPOLY         0xEDB88320L
ULONG crctable[256];
ULONG rd_crc;

//-------- comments
#define comm_cpr_hf(a,b) (a+b)
INT comm_cpr_size;
CHAR *comm;

//-------- file creation
#define fileexists(name) (!access(name,F_OK))
