#include "unace.h"
#include "uac_crc.c"
#include "uac_dcpr.c"
#include "uac_comm.c"
#include "uac_crt.c"
#include "uac_sys.c"

init_unace()                                          /* initializes unace */
{
  printf("\nUNACE v1.0a    public version\n");

  make_crctable();                                 /* initialize CRC table */
  dcpr_init();                                 /* initialize decompression */

  set_handler();                                        /* ctrl+break etc. */
}

#define max_head_rd (sizeof(head)-((INT)&head.HEAD_TYPE-(INT)&head))
INT read_header(INT print_err)            /* reads any header from archive */
{
USHORT rd,head_size,crc_ok;
LONG crc;
  lseek(archan,skipsize,SEEK_CUR);                   /* skip ADDSIZE block */

  if (read(archan,&head,4)<4) return(0);       /* read CRC and header size */

                           /* read max_head_rd bytes into header structure */
  head_size=head.HEAD_SIZE;
  rd=(head_size>max_head_rd)?max_head_rd:head_size;
  if (rd>max_head_rd) rd=max_head_rd;
  if (read(archan,&head.HEAD_TYPE,rd)<rd) return(0);head_size-=rd;
  crc=getcrc(CRC_MASK,&head.HEAD_TYPE,rd);

  while (head_size) {                               /* skip rest of header */
    rd=(head_size>size_buf)?size_buf:head_size;
    if (read(archan,buf,rd)<rd) return(0);head_size-=rd;
    crc=getcrc(crc,buf,rd);
  }

  skipsize=(head.HEAD_FLAGS&ACE_ADDSIZE)?head.ADDSIZE:0;    /* get ADDSIZE */

                                                       /* check header CRC */
  if (!(crc_ok=head.HEAD_CRC==(crc&0xffff)) && print_err)
    printf("\nError: archive is broken\n");

  return(crc_ok);
}
                      /* maximum SFX module size (needed by read_arc_head) */
#define max_sfx_size 65536
INT read_arc_head()        /* searches for the archive header and reads it */
{
INT i,flags,buf_pos=0;
LONG arc_head_pos,old_fpos,fpos=0;

  memset(buf,0,size_buf);
  while (!eof(archan) && fpos<max_sfx_size) {
    old_fpos=fpos;
    fpos+=read(archan,&buf[buf_pos],size_buf-buf_pos);

    for (i=0;i<size_buf;i++) {                     /* look for the acesign */
      if (!memcmp(acesign,&buf[i],acesign_len)) {
                             /* seek to then probable begin of the archive */
        arc_head_pos=old_fpos+i-buf_pos-((INT)mhead.ACESIGN-(INT)&mhead);
        lseek(archan,arc_head_pos,SEEK_SET);
        if (read_header(0)) {                /* try to read archive header */
          flags=mhead.HEAD_FLAGS;
          adat.sol=(flags & ACE_SOLID)>0;
          adat.vol=(flags & ACE_MULT_VOL)>0;
          adat.vol_num=mhead.VOL_NUM;
          adat.time_cr=*(dos_ftime*)&mhead.TIME_CR;
          return(1);
        }
      }
                                 /* was no archive header, continue search */
      lseek(archan,fpos,SEEK_SET);
    }
    memcpy(buf,&buf[size_buf-512],512);buf_pos=512;  /* keep 512 old bytes */
  }
  return(0);
}

INT open_archive(INT print_err)                /* open archive (or volume) */
{
CHAR av_str[80];

  archan=open(aname,O_RDONLY | O_BINARY);                          /* open */

  if (archan==-1) {
    printf("\nError opening file %s",aname);
    return(0);
  }
  if (!read_arc_head()) {                           /* read archive header */
    if (print_err) printf("\nInvalid archive file: %s\n",aname);
    close(archan);
    return(0);
  }

  printf("\n\n  Processing archive %s\n",aname);
  if (head.HEAD_FLAGS & ACE_AV) {
    printf("\nAuthenticity Verification:");                  /* get the AV */
    sprintf(av_str,"\ncreated on %d.%d.%d by ",
      adat.time_cr.day,adat.time_cr.month,1980+adat.time_cr.year);
    printf(av_str);
    strncpy(av_str,mhead.AV,mhead.AV_SIZE);
    av_str[mhead.AV_SIZE]=0;
    printf("%s\n",av_str);
  }
  comment_out("Main comment");                       /* print main comment */
  return(1);
}

get_next_volname()                         /* get file name of next volume */
{
CHAR *cp;
INT num;
  if ((cp=(CHAR*)strrchr(aname,'.'))==NULL || !*(cp+1)) num=-1;
   else {
    cp++;
    num=(*(cp+1)-'0')*10+*(cp+2)-'0';
    if (!in(num,0,99)) num=-1;
    if (in(*cp,'0','9')) num+=(*cp-'0')*100;
  }
  num++;

  if (num<100) *cp='C'; else *cp=num/100+'0';
  *(cp+1)=(num/10)%10+'0';
  *(cp+2)=num%10+'0';
}

INT proc_vol()                                             /* opens volume */
{
INT i;
CHAR s[80],t[80];
  if (!fileexists(aname) || !f_allvol_pr) {
   do {
    sprintf(s,"Ready to process %s?",aname);
    beep();
    i=wrask(s);                                /* ask whether ready or not */
    f_allvol_pr=(i==1);                /* "Always" --> process all volumes */
    if (i>=2) {
      f_err=ERR_FOUND;
      return(0);
    }
   } while (!fileexists(aname));
  }

  if (!open_archive(1)) {                                   /* open volume */
    printf("\nError while opening archive. File not found or archive broken.\n");
    f_err=ERR_OPEN;
    return(0);
  }

  return(1);
}

INT proc_next_vol()                         /* open next volume to process */
{
  close(archan);                                           /* close handle */
  get_next_volname();                      /* get file name of next volume */

  if (!proc_vol()) return(0);   /* try to open volume, read archive header */
  return(read_header(1));                               /* read 2nd header */
}

INT read_adds_blk(CHAR *buffer,INT len)     /* reads part of ADD_SIZE block*/
{
INT rd=0,l=len;
LONG i;
  while (!f_err && len && skipsize) {
    i=(skipsize>len)?len:skipsize;
    skipsize-=i;

    errno=0;
    rd+=read(archan,buffer,i);
    if (errno) {
      printf("\nRead error\n");
      f_err=ERR_READ;
    }

    buffer+=i;
    len-=i;

    if (!skipsize)                 /* if block is continued on next volume */
      if (head.HEAD_FLAGS & ACE_SP_AFTER) proc_next_vol(); else break;
  }
  return(rd>l?l:rd);
}

crc_print()                                  /* checks CRC, prints message */
{
INT crc_not_ok=rd_crc!=fhead.CRC32;                   /* check CRC of file */

  if (!f_err) {                                           /* print message */
    printf(crc_not_ok?"          CRC-check error":"          CRC OK");flush;
    if (crc_not_ok) delay(delay_len);
  }
}

analyze_file()                       /* analyzes file (for solid archives) */
{
  printf("\n Analyzing");flush;
                                                        /* decompress only */
  while (!cancel() && (dcpr_adds_blk(buf_wr,size_wrb))) {
  }
  crc_print();
}

extract_file()                                        /* extracts one file */
{
INT rd,crc_not_ok;
  printf("\n Extracting");flush;
                                                       /* decompress block */
  while (!cancel() && (rd=dcpr_adds_blk(buf_wr,size_wrb))) {
    if (write(wrhan,buf_wr,rd)!=rd) {                       /* write block */
      printf("\nWrite error\n");
      f_err=ERR_WRITE;
    }
  }
  crc_print();
}

extract_files()                          /*  extracts all files of archive */
{
CHAR file[PATH_MAX];
  while (!cancel() && read_header(1)) {
    if (head.HEAD_TYPE==FILE_BLK) {
      comment_out("File comment");                    /* show file comment */
      ace_fname(file,&head);                              /* get file name */
      printf("\n%s",file);
      dcpr_init_file();                /* initialize decompression of file */
      if (!f_err) {
        wrhan=create_dest_file(file,(INT)fhead.ATTR);       /* create file */
        if (wrhan!=-1) {
          extract_file();                                    /* extract it */

#ifdef DOS                                                /* set file time */
          _dos_setftime(wrhan,(USHORT)(fhead.FTIME>>16),(USHORT)fhead.FTIME);
#endif
          close(wrhan);
#ifdef DOS
          _dos_setfileattr(file,(UINT)fhead.ATTR);  /* set file attributes */
#endif
          if (f_err) remove(file);
        } else if (adat.sol) analyze_file();     /* analyze file if needed */
      }
    }
  }
}

main(INT argc,CHAR *argv[])                       /* processes the archive */
{
CHAR *s;

  init_unace();                                        /* initialize unace */

  strcpy(aname,argv[1]);                               /* get archive name */
  if (!(s=(CHAR*)strrchr(aname,'\\'))) s=aname;
  if (!strrchr(s,'.')) strcat(aname,".ACE");

  if (!open_archive(0)) {                       /* open archive to process */
    printf("\n\nUsage: UNACE <archive>\n");
    f_err=ERR_CLINE;
  } else {

    if (adat.vol_num) printf("\nFirst volume of archive required!\n");
      else extract_files();                               /* extract files */

    close(archan);
    if (f_err) {
      printf("\nError occurred during extraction\n");
      if (f_criterr)
        printf("Critical error on drive %c\n",f_criterr);
    }
  }
  printf("\n");
  return(f_err);
}
