@rem ***********************************************************************
@rem *                                                                     *
@rem * SMS.BAT - Batch file for installation over a LAN using SMS          *
@rem *                                                                     *
@rem * Parameters :-                                                       *
@rem *                                                                     *
@rem *   InstallType : compact or complete                                 *
@rem *                                                                     *
@rem * Examples :-                                                         *
@rem *                                                                     *
@rem *   sms compact                                                       *
@rem *   sms complete                                                      *
@rem *                                                                     *
@rem * Description :-                                                      *
@rem *                                                                     *
@rem *   This is a batch file for installing MQSeries for Windows on       *
@rem *   Windows NT 4.0 or Windows 95 workstations across a LAN using      *
@rem *   SMS (Systems Management Server).  It assumes that SMS has been    *
@rem *   set up on the server and on all clients, and that a package has   *
@rem *   been created to call this batch file with the relevant parameter  *
@rem *   (compact or complete).                                            *
@rem *                                                                     *
@rem *   Also, the files on the CD-ROM or floppy disks must be copied into *
@rem *   the following directory structure under a sub-directory of your   *
@rem *   choosing :-                                                       *
@rem *                                                                     *
@rem *   --\YourSubDir                                                     *
@rem *       +                                                             *
@rem *       sms.bat - This batch file                                     *
@rem *       +                                                             *
@rem *       \Disk1  - Sub directory containing all the files on disk 1    *
@rem *                  or in the DISK1 directory of the CD-ROM            *
@rem *       +                                                             *
@rem *       \Disk2  - Sub directory containing all the files on disk 2    *
@rem *                  or in the DISK2 directory of the CD-ROM            *
@rem *       +                                                             *
@rem *       \Disk3  - Sub directory containing all the files on disk 3    *
@rem *                   or in the DISK3 directory of the CD-ROM           *
@rem *                                                                     *
@rem *   Two files are created in the target machines C:\WINDOWS           *
@rem *   directory :-                                                      *
@rem *                                                                     *
@rem *     MQSERIES.LOG - Log file generated by InstallShield.             *
@rem *                                                                     *
@rem *     MQSERIES.MIF - Management Information File generated by         *
@rem *                    InstallShield.                                   *
@rem *                                                                     *
@rem * Statement:     Licensed Materials - Property of IBM                 *
@rem *                                                                     *
@rem *                5639-B69 (C) Copyright IBM Corp. 1996, 1997          *
@rem *                                                                     *
@rem *                U.S. Government Users Restricted Rights - use,       *
@rem *                duplication or disclosure restricted by GSA ADP      *
@rem *                Schedule Contract with IBM Corp.                     *
@rem *                                                                     *
@rem *                                                                     *
@rem ***********************************************************************

@echo off
:start
cd disk1

if %1. == . goto specify
if %1 == compact goto compact
if %1 == COMPACT goto compact
if %1 == complete goto complete
if %1 == COMPLETE goto complete

:unknown
echo unknown install type - %1
goto finish

:specify
echo You must specify a Complete or Compact install ('sms complete' for complete install)
goto finish

:compact
rem Compact install
setup -s -SMS -mMQSeries.mif -f1.\compact.iss -f2%windir%\MQSeries.log
goto finish

:complete
rem Complete install
setup -s -SMS -mMQSeries.mif -f1.\complete.iss -f2%windir%\MQSeries.log

:finish
cd ..
