{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: QuickReport 2.0 for Delphi 1.0 - 3.0                    ::
  ::                                                         ::
  :: TQREditor example application                           ::
  ::                                                         ::
  :: Copyright (c) 1997 QuSoft AS                            ::
  :: All Rights Reserved                                     ::
  ::                                                         ::
  :: web: http://www.qusoft.no    mail: support@qusoft.no    ::
  ::                              fax: +47 22 41 74 91       ::
  ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

unit qredform;

interface

uses
  Wintypes, winprocs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, quickrpt, qrextra, StdCtrls, Qrctrls, qrprntr, Menus, QRAbout;

type
  TEditorForm = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    NewReport: TMenuItem;
    OpenReport: TMenuItem;
    SaveReport: TMenuItem;
    SaveReportAS: TMenuItem;
    CloseFile: TMenuItem;
    N1: TMenuItem;
    PreviewReport: TMenuItem;
    PrintReport: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    ReportLayout: TMenuItem;
    DataSetup: TMenuItem;
    Grouping: TMenuItem;
    Help1: TMenuItem;
    AboutQuickReport1: TMenuItem;
    QREditor: TQREditor;
    procedure NewReportClick(Sender: TObject);
    procedure OpenReportClick(Sender: TObject);
    procedure SaveReportClick(Sender: TObject);
    procedure SaveReportASClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure CloseFileClick(Sender: TObject);
    procedure PreviewReportClick(Sender: TObject);
    procedure PrintReportClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure QREditorCloseReport(Sender: TObject);
    procedure AboutQuickReport1Click(Sender: TObject);
  private
    function AskAndSave : boolean;
    procedure SetMenuItems;
  end;

var
  EditorForm: TEditorForm;

implementation

{$R *.DFM}

procedure TEditorForm.SetMenuItems;
begin
  SaveReport.Enabled := QREditor.Editing;
  SaveReportAs.Enabled := QREditor.Editing;
  CloseFile.Enabled := QREditor.Editing;
  PreviewReport.Enabled := QREditor.Editing;
  PrintReport.Enabled := QREditor.Editing;
  ReportLayout.Enabled := QREditor.Editing;
  DataSetup.Enabled := QREditor.Editing;
  Caption := 'QREditor demo';
  if QREditor.Editing then
  begin
    if QREditor.Filename <> '' then
      Caption := Caption + ' - '+QREditor.Filename
    else
      Caption := Caption + ' - (untitled)';
  end
end;

procedure TEditorForm.NewReportClick(Sender: TObject);
begin
  if QREditor.Editing then
  begin
    if AskAndSave then
      QREditor.NewReport;
  end else
  QREditor.NewReport;
end;

procedure TEditorForm.OpenReportClick(Sender: TObject);
begin
  if QREditor.Editing then
  begin
    if AskAndSave then
      QREditor.OpenReport;
  end else
    QREditor.OpenReport;
end;

procedure TEditorForm.SaveReportClick(Sender: TObject);
begin
  QREditor.SaveReport;
end;

procedure TEditorForm.SaveReportASClick(Sender: TObject);
var
  OldFilename : string;
begin
  OldFilename := QREditor.Filename;
  QREditor.Filename := '';
  QREditor.SaveReport;
  if QREditor.Filename = '' then
    QREditor.Filename := OldFilename;
end;

procedure TEditorForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

function TEditorForm.AskAndSave : boolean;
var
  Filename : string;
  Answer : word;
begin
  if QREditor.Filename = '' then
    Filename := '(untitled)'
  else
    Filename := QREditor.Filename;
  Answer := MessageDlg('Save report '+Filename+'?', mtConfirmation, mbYesNoCancel, 0);
  Result := Answer <> mrCancel;
  if Answer = mrYes then QREditor.SaveReport;
end;

procedure TEditorForm.CloseFileClick(Sender: TObject);
begin
  if AskAndSave then
    QREditor.CloseReport;
end;

procedure TEditorForm.PreviewReportClick(Sender: TObject);
begin
  QREditor.Report.Preview;
end;

procedure TEditorForm.PrintReportClick(Sender: TObject);
begin
  QREditor.Report.Print;
end;

procedure TEditorForm.FormCreate(Sender: TObject);
begin
  SetMenuItems;
end;

procedure TEditorForm.QREditorCloseReport(Sender: TObject);
begin
  SetMenuItems;
end;

procedure TEditorForm.AboutQuickReport1Click(Sender: TObject);
begin
  with TQRAboutBox.Create(Application) do
  try
    ShowModal
  finally
    Free;
  end;
end;

end.
