/*
Central Ad PRO 3.0J
Copyright (c) 1997, Central Ad Software. - All rights reserved
Central Ad PRO is a trademark of Central Ad Software.

****************************************************************
  Modification and/or redistribution of this code is forbidden
****************************************************************

The following paragraph is an extract from the license 
agreement regarding the use of this software:

Permitted Uses. Your Authorized Operators may Use the Licensed
Program in the Licensed Operating Environment strictly for Your
internal business operations and to process Your own data. You may
also review the source code to the Licensed Program strictly as a
technical reference and subject to the restrictions of Section 5
("Reservation of Rights"). Modifications to the source code and
preparation of adaptations or derivative works of the Licensed
Program are not authorized by this  Agreement.
...
Rights to Licensed Program. The intellectual property rights in
the Licensed Program shall at all times remain the exclusive
property of Licensor or other owner identified in the Documentation.

*/
int random_unique_identifier;

#include "common.hpp"

char* get_group_name(void)
{
FILE *fstream;
char filename[500];
char group[200];
char str_cpy[400];
int i = 1;

if(getenv("PATH_INFO")!=NULL)
	strcpy(str_cpy, getenv("PATH_INFO"));
else{
	if(getenv("DOCUMENT_URI")!=NULL)
		strcpy(str_cpy, getenv("DOCUMENT_URI"));
	else
	   return("defaultgp");

} /* end else*/

while(str_cpy[i] != '.' && str_cpy[i] != '\0'){
	if (str_cpy[i] == '/')
		str_cpy[i] = '_';

	group[i-1] = str_cpy[i];
	++i;
	if (i > 198)
   	return("defaultgp");
} /* end while*/

group[i-1] = NULL;
/* check if group file exists*/
strcpy(filename, LOG_PATH);
strcat(filename, group);
strcat(filename, ".grp");
if((fstream = fopen(filename, "r")) != NULL){
	fclose(fstream);
	return (strdup(group));
} /* end if*/

/* if not, continue checking directories for valid group names      */
for (i = strlen(group);i >= 0;i--){
	if(group[i] == '_'){
		group[i] = '\0';
		strcpy(filename, LOG_PATH);
		strcat(filename, group);
		strcat(filename, ".grp");
		if((fstream = fopen(filename, "r")) != NULL){
			fclose(fstream);
			return (strdup(group));
		} /* end if */
	} /* end if      */
} /* end for          */

return ("defaultgp");
} /* end get_group_name
    */

char* get_random_ad(char* group)
{
FILE *fstream;
char ad[300];
char filename[300];
int i=0, j=0, rand_num, tried=2000;
time_t t;
int start_month, start_day, start_year, current_month, current_day, current_year;
char *current_date;
char *start_date;

/*filename gets full path of group name       */
strcpy(filename, LOG_PATH);
strcat(filename, group);
strcat(filename, ".grp");
/*seed random number generator       */
srand((unsigned) time(&t));

random_unique_identifier =  (rand() % 500) + 1;

if((fstream = fopen(filename, "r")) == NULL){
	strcpy(filename, LOG_PATH);
	strcat(filename, "defaultgp.grp");
	if((fstream = fopen(filename, "r")) == NULL)
		return("blank");
} /* end if */

current_date = strdup(get_date());

while(j < 1000){
	ad[0] = '\0';
	while(ad[0] == '\0' || ad[0] == '\n' || ad[0] == ' '){
		while ((fgets(ad, 200, fstream)) != NULL)
			++i;
		if (i < 1)
      	{
         fclose(fstream);
			return ("blank");
         }
		rand_num = (rand() % i) + 1;
      if (rand_num == tried)
      	{
         if (rand_num%2)
         	++rand_num;
         else
         	--rand_num;
         }
		rewind(fstream);
		for (i = 0;i < rand_num ;++i)
			fgets(ad, 200, fstream);
		rewind(fstream);
      i=0;
	} /* end while */


/* Check Date
  */
strcpy(filename, LOG_PATH);
strcat(filename, remove_ret(ad));
strcat(filename, ".inf");

start_date = strdup(get_from_file(filename, 3));
if ((strcmp(filename, "ERROR")) == 0)
{
	fclose(fstream);
	return "blank";
   }

if((strcmp(current_date, start_date))==0)
		break; /* out of main while loop*/
      
	start_month = calculate_month(start_date);
	current_month =  calculate_month(current_date); 
	start_day = calculate_day(start_date);
	current_day =  calculate_day(current_date);
	start_year = calculate_year(start_date);
	current_year =  calculate_year(current_date);

if( start_year < current_year )
	break; /*ut of main while loop*/
else if(start_year == current_year){
	if( start_month < current_month)
		break; /* out of main while loop*/
	else if(  start_month == current_month){
		if( start_day <= current_day )
			break; /* out of main while loop*/
		} /* end second else if*/
	} /* end first else if*/
 ++j; /* increment main while loop counter*/
} /* end main while loop*/

if(ad[0] == '\0' || ad[0] == '\n' || ad[0] == ' ')
{
   fclose(fstream);
	return("blank");
   }

fclose(fstream);
return (remove_ret(ad));
} /* end get_random_ad*/



int send_ad_html(char* ad, char* group)
{
FILE *fstream;
char abs_address[200];
char alt[300];
char height[200];
char width[200];
char filename[300];
char target[30];
char border[30];
char href[500];
char imgsrc[500];
char temp[300];
char text_under[601];
int i=0;
int j;


while (ad[0] == '\n' || ad[0] == '\0' || ad[0] == ' '){
	strcpy(ad, get_random_ad(group));
	if(i > 200){
		strcpy(ad, "blank");
		break;
	} /*end if*/
   ++i;
} /* end while*/

strcpy(abs_address, ABS_ADDRESS);
strcpy(alt, get_ALT(remove_ret(ad)));


strcpy(filename, LOG_PATH);
strcat(filename, remove_ret(ad));
strcat(filename, ".inf");

if ((fstream = fopen(filename, "r")) == NULL){
	strcpy(width, "\0");
	strcpy(height, "\0");
	strcpy(imgsrc, "\0");
	strcpy(href, "\0");
} /*end if*/
else{
	for(j = 1;j < 5;j++)
		fgets(temp, 300, fstream);
	/* width stored on fifth line*/
	fgets(width, 200, fstream);
	if((strcmp(width, "ERROR")==0))
		strcpy(width, "\0");
	/* height stored on sixth line*/
	fgets(height, 200, fstream);
	if((strcmp(height, "ERROR")==0))
		strcpy(height, "\0");

		fgets(text_under, 600, fstream);
      fgets(border, 29, fstream);
      fgets(target, 29, fstream);

	/* imgsrc stored on tenth line*/
	fgets(imgsrc, 500, fstream);
	if((strcmp(imgsrc, "ERROR")==0))
		strcpy(imgsrc, "\0");
	/* href stored on eleventh line*/
	fgets(href, 500, fstream);
	if((strcmp(href, "ERROR")==0))
		strcpy(href, "\0");

	fclose(fstream);
} /* end else*/


/* output correct html*/

printf("<a href=\"%sredirect.cgi/%d?AD=%s\" target=\"%s\"  %s >", remove_ret(ABS_ADDRESS), random_unique_identifier, remove_ret(ad), remove_ret(target), remove_ret(href));

printf("<img src=\"%sgetimage.cgi/%d?AD=%s\"  %s border=%s  alt=\"%s\" ", remove_ret(ABS_ADDRESS), random_unique_identifier,remove_ret(ad),  remove_ret(imgsrc), remove_ret(border), remove_ret(alt));

if(width[0] != '\0' &&  width[0] != '\n'  &&  width[0] != ' ' && height[0] != '\0' &&  height[0] != '\n'  &&  height[0] != ' ' )
	printf(" width=%s height=%s >%s</a>", remove_ret(width), remove_ret(height), remove_ret(text_under));
else
	printf(">%s</a>", remove_ret(text_under));
          
return 0;
} /* end send_ad_html*/


int main(int argc, char **argv)
{

char group[200];
char ad[200];


/*get_query();*/
/*printf("Content-type:  text/plain\n\nHI");
return 1; */

load_global_variables();

if (argc > 1){
	/* No need for a header because it must be a cmd call...*/
	strcpy(group, argv[1]);
} /* end if*/
else{
      printf("%s\n\n", SSIRAND_HEADER);

		strcpy(group, get_group_name());
	} /* end else*/




printf("\n<!-- GROUP=%s-->\n", group);





strcpy(ad, get_random_ad(group));



send_ad_html(ad, group);


return 1;
} /* end main*/

