# Zinc Application Framework 5.0 attrtest makefile
# Uses Watcom C/C++ 10.6 and 11.0 with Watcom WMAKE.EXE (excluding QNX)
#
# Builds Zinc attrtest programs for 32 bit DOS (using DOS4GW), Windows 16,
#  Windows 32, OS2, DESQview/X (using Motif toolkit), QNX (Motif).
#    wmake -f watcom.mak dos32
#    wmake -f watcom.mak win16
#    wmake -f watcom.mak win32
#    wmake -f watcom.mak os2
#    wmake -f watcom.mak dvx
#    make -f watcom.mak qnx
#
# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
# DOS 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# WIN 16:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\WIN;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB286\WIN;C:\WATCOM\LIB286;C:\ZINC\LIB\WCCPP
# WIN 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\NT;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\NT;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# OS/2:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\OS2;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\OS2;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# DESQView/X:
#    set INCLUDE=.;C:\DVX\INCLUDE;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\DVX\LIB\C386;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
#
# ----- General Definitions -------------------------------------------------
VERSION=watcom
PERSISTENCE=all

ZAF_ROOT=..

!include $(ZAF_ROOT)\include\optswat.mak

# ----- Usage ---------------------------------------------------------------
usage: .SYMBOLIC
	@echo This makefile supports Watcom 10.6 and 11.0
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo wmake -f watcom.mak dos32
	@echo wmake -f watcom.mak win16
	@echo wmake -f watcom.mak win32
	@echo wmake -f watcom.mak os2
	@echo wmake -f watcom.mak dvx
	@echo make -f watcom.mak qnx
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean: .SYMBOLIC
	z_clean

# ----- DOS 32 bit (DOS4GW extender) Attrtest Programs ----------------------
# This is pending.

# ----- Windows 16 bit Attrtest Programs ------------------------------------
win16: wbnum16.exe wbtn16.exe wcombo16.exe wdate16.exe wdisp16.exe wfstr16.exe &
	wgmgmt16.exe wgroup16.exe whlist16.exe wicon16.exe wint16.exe wntbk16.exe &
	wprgrs16.exe wprmpt16.exe wreal16.exe wsclwn16.exe wscrl16.exe wspin16.exe &
	wstat16.exe wstr16.exe wtable16.exe wtbar16.exe wtext16.exe wtime16.exe &
	wtree16.exe wtritm16.exe wutime16.exe wvlist16.exe 

wbnum16.exe: bnum.ob1 format.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wbnum16 F bnum.ob1,format.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wbtn16.exe: button.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wbtn16 F button.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wcombo16.exe: combo.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wcombo16 F combo.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wdate16.exe: date.ob1 format.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wdate16 F date.ob1,format.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wdisp16.exe: display.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wdisp16 F display.ob1$(WIN_OBJS) L $(WIN_LIBS)

wfstr16.exe: fstr.ob1 format.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wfstr16 F fstr.ob1,format.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wgmgmt16.exe: gmgmt.ob1
 	$(WIN_LINK) $(WIN_LINK_OPTS) N wgmgmt16 F gmgmt.ob1$(WIN_OBJS) L $(WIN_LIBS)

wgroup16.exe: group.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wgroup16 F group.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

whlist16.exe: hlist.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N whlist16 F hlist.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wicon16.exe: icon.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wicon16 F icon.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wint16.exe: integer.ob1 format.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wint16 F integer.ob1,format.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wntbk16.exe: ntbk.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wntbk16 F ntbk.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wprgrs16.exe: prgrs.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wprgrs16 F prgrs.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wprmpt16.exe: prompt.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wprmpt16 F prompt.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wreal16.exe: real.ob1 format.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wreal16 F real.ob1,format.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wsclwn16.exe: sclwin.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wsclwn16 F sclwin.ob1$(WIN_OBJS) L $(WIN_LIBS)

wscrl16.exe: scroll.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wscrl16 F scroll.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wspin16.exe: spin.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wspin16 F spin.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wstat16.exe: status.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wstat16 F status.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wstr16.exe: string.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wstr16 F string.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtable16.exe: table.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtable16 F table.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtbar16.exe: tbar.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtbar16 F tbar.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtext16.exe: text.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtext16 F text.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtime16.exe: time.ob1 format.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtime16 F time.ob1,format.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtree16.exe: tree.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtree16 F tree.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtritm16.exe: tritm.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtritm16 F tritm.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wutime16.exe: utime.ob1 format.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wutime16 F utime.ob1,format.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

wvlist16.exe: vlist.ob1 maintest.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wvlist16 F vlist.ob1,maintest.ob1$(WIN_OBJS) L $(WIN_LIBS)

# ----- Windows 32 bit Attrtest Programs ------------------------------------
win32: wbnum32.exe wbtn32.exe wcombo32.exe wdate32.exe wdisp32.exe wfstr32.exe &
	wgmgmt32.exe wgroup32.exe whlist32.exe wicon32.exe wint32.exe wntbk32.exe &
	wprgrs32.exe wprmpt32.exe wreal32.exe wsclwn32.exe wscrl32.exe wspin32.exe &
	wstat32.exe wstr32.exe wtable32.exe wtbar32.exe wtext32.exe wtime32.exe &
	wtree32.exe wtritm32.exe wutime32.exe wvlist32.exe 

wbnum32.exe: bnum.obw format.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wbnum32 F bnum.obw,format.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wbtn32.exe: button.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wbtn32 F button.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wcombo32.exe: combo.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wcombo32 F combo.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wdate32.exe: date.obw format.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wdate32 F date.obw,format.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wdisp32.exe: display.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wdisp32 F display.obw$(W32_OBJS) L $(W32_LIBS)

wfstr32.exe: fstr.obw format.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wfstr32 F fstr.obw,format.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wgmgmt32.exe: gmgmt.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wgmgmt32 F gmgmt.obw$(W32_OBJS) L $(W32_LIBS)

wgroup32.exe: group.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wgroup32 F group.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

whlist32.exe: hlist.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N whlist32 F hlist.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wicon32.exe: icon.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wicon32 F icon.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wint32.exe: integer.obw format.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wint32 F integer.obw,format.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wntbk32.exe: ntbk.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wntbk32 F ntbk.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wprgrs32.exe: prgrs.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wprgrs32 F prgrs.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wprmpt32.exe: prompt.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wprmpt32 F prompt.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wreal32.exe: real.obw format.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wreal32 F real.obw,format.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wsclwn32.exe: sclwin.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wsclwn32 F sclwin.obw$(W32_OBJS) L $(W32_LIBS)

wscrl32.exe: scroll.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wscrl32 F scroll.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wspin32.exe: spin.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wspin32 F spin.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wstat32.exe: status.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wstat32 F status.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wstr32.exe: string.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wstr32 F string.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wtable32.exe: table.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtable32 F table.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wtbar32.exe: tbar.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtbar32 F tbar.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wtext32.exe: text.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtext32 F text.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wtime32.exe: time.obw format.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtime32 F time.obw,format.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wtree32.exe: tree.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtree32 F tree.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wtritm32.exe: tritm.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtritm32 F tritm.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wutime32.exe: utime.obw format.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wutime32 F utime.obw,format.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

wvlist32.exe: vlist.obw maintest.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wvlist32 F vlist.obw,maintest.obw$(W32_OBJS) L $(W32_LIBS)

# ----- Windows 32 dll bit Attrtest Programs --------------------------------
win32dll: wbnum.exe wbtn.exe wcombo.exe wdate.exe wdisp.exe wfstr.exe &
	wgmgmt.exe wgroup.exe whlist.exe wicon.exe wint.exe wntbk.exe &
	wprgrs.exe wprmpt.exe wreal.exe wsclwn.exe wscrl.exe wspin.exe &
	wstat.exe wstr.exe wtable.exe wtbar.exe wtext.exe wtime.exe &
	wtree.exe wtritm.exe wutime.exe wvlist.exe 

wbnum.exe: bnum.obi format.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wbnum F bnum.obi,format.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wbtn.exe: button.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wbtn F button.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wcombo.exe: combo.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wcombo F combo.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wdate.exe: date.obi format.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wdate F date.obi,format.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wdisp.exe: display.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wdisp F display.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wfstr.exe: fstr.obi format.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wfstr F fstr.obi,format.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wgmgmt.exe: gmgmt.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wgmgmt F gmgmt.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wgroup.exe: group.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wgroup F group.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

whlist.exe: hlist.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N whlist F hlist.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wicon.exe: icon.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wicon F icon.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wint.exe: integer.obi format.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wint F integer.obi,format.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wntbk.exe: ntbk.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wntbk F ntbk.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wprgrs.exe: prgrs.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wprgrs F prgrs.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wprmpt.exe: prompt.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wprmpt F prompt.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wreal.exe: real.obi format.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wreal F real.obi,format.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wsclwn.exe: sclwin.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wsclwn F sclwin.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wscrl.exe: scroll.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wscrl F scroll.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wspin.exe: spin.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wspin F spin.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wstat.exe: status.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wstat F status.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wstr.exe: string.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wstr F string.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtable.exe: table.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtable F table.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtbar.exe: tbar.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtbar F tbar.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtext.exe: text.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtext F text.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtime.exe: time.obi format.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtime F time.obi,format.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtree.exe: tree.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtree F tree.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtritm.exe: tritm.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtritm F tritm.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wutime.exe: utime.obi format.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wutime F utime.obi,format.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wvlist.exe: vlist.obi maintest.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wvlist F vlist.obi,maintest.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

# ----- OS/2 Attrtest Programs ----------------------------------------------
# This is pending.

# ----- QNX Motif Attrtest Programs -----------------------------------------
qnx: attr1 attr2 attr3

attr1: mbnum mbutton mcombo mdate mdisplay mfstr mgmgmt mgroup mhlist micon
attr2: minteger mntbk mprgrs mprompt mreal msclwin mscroll mspin mstatus
attr3: mstring mtable mtbar mtext mtime mtree mtritm mutime mvlist

mbnum: bnum.o format.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ bnum.o format.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mbutton: button.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ button.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mcombo: combo.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ combo.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mdate: date.o format.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ date.o format.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mdisplay: display.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ display.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mfstr: fstr.o format.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ fstr.o format.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mgmgmt: gmgmt.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ gmgmt.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mgroup: group.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ group.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mhlist: hlist.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ hlist.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

micon: icon.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ icon.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

minteger: integer.o format.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ integer.o format.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mntbk: ntbk.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ ntbk.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mprgrs: prgrs.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ prgrs.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mprompt: prompt.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ prompt.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mreal: real.o format.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ real.o format.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

msclwin: sclwin.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ sclwin.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mscroll: scroll.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ scroll.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mspin: spin.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ spin.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mstatus: status.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ status.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mstring: string.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ string.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtable: table.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ table.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtbar: tbar.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ tbar.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtext: text.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ text.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtime: time.o format.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ time.o format.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtree: tree.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ tree.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtritm: tritm.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ tritm.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mutime: utime.o format.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ utime.o format.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mvlist: vlist.o maintest.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ vlist.o maintest.o $(QNX_LIB_DIRS) $(QNX_LIBS)

qclean:
	rm -f *.o core mbnum mbutton mcombo mdate mdisplay mfstr mgmgmt mgroup mhlist micon
	rm -f minteger mntbk mprgrs mprompt mreal msclwin mscroll mspin mstatus
	rm -f mstring mtable mtbar mtext mtime mtree mtritm mutime mvlist
