//	Zinc Application Framework - VLIST.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafVtList
	{ ZAF_ITEXT("Vertical scroll"),   0, TST_TOGGLE_VERTICAL_SCROLL },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

int CompareDescending(void *object1, void *object2)
{
	return (stricmp(((ZafWindowObject *)object2)->Text(), ((ZafWindowObject *)object1)->Text()));
}

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafVtList
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafVtList(50, 1, 20, 3)
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafVtList::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 11)
{
	// The test object can place settings vlist boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Vlist"));

	// Add settings objects.
	Add(new ZafPrompt(1, 8, 15, new ZafStringData("# of new objects:")));
	ZafSpinControl *newObjSpin = new ZafSpinControl(18, 8, 8, new ZafIntegerData(1L));
	newObjSpin->SetStringID(ZAF_ITEXT("NEW_OBJ_SPIN"));
	newObjSpin->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(0L)));
	Add(newObjSpin);
	ZafButton *newObjButton = new ZafButton(27, 8, 10, 1, new ZafStringData("Add** ->"));
	newObjButton->SetAutoSize(false);
	newObjButton->SetValue(TST_ADD_OBJECTS);
	newObjButton->SetSendMessageWhenSelected(true);
	Add(newObjButton);

	// Create sort type combo box.
	ZafComboBox *sortTypeCombo = new ZafComboBox(1, 9, 20, 3);
	sortTypeCombo->SetStringID(ZAF_ITEXT("SORT_COMBO"));
	sortTypeCombo->SetViewOnly(true);
	sortTypeCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("No sort *"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SORT_NONE);
	attr->SetNumberID((ZafNumberID)TST_SET_SORT_NONE);
	sortTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Auto sort *"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SORT_AUTO);
	attr->SetNumberID((ZafNumberID)TST_SET_SORT_AUTO);
	sortTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Reverse sort *"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SORT_REVERSE);
	attr->SetNumberID((ZafNumberID)TST_SET_SORT_REVERSE);
	sortTypeCombo->Add(attr);

	Add(sortTypeCombo);

	// Create selection type combo box.
	ZafComboBox *selectionTypeCombo = new ZafComboBox(27, 9, 20, 3);
	selectionTypeCombo->SetViewOnly(true);
	selectionTypeCombo->SetStringID(ZAF_ITEXT("SELECTION_TYPE_COMBO"));
	selectionTypeCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Single Selection"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SELECTION_SINGLE);
	attr->SetNumberID((ZafNumberID)TST_SET_SELECTION_SINGLE);
	selectionTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Multiple Selection"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SELECTION_MULTIPLE);
	attr->SetNumberID((ZafNumberID)TST_SET_SELECTION_MULTIPLE);
	selectionTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Extended Selection"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SELECTION_EXTENDED);
	attr->SetNumberID((ZafNumberID)TST_SET_SELECTION_EXTENDED);
	selectionTypeCombo->Add(attr);

	Add(selectionTypeCombo);

	// Add the test object.
	int cnt;
	testObject = new TestObj;
	ZafVtList *vlist = DynamicPtrCast(testObject, ZafVtList);
	vlist->Add(new ZafScrollBar(0, 0, 0, 0));
	for (cnt = 0; cnt < 10; cnt++)
	{
		ZafIChar buf[32];
		sprintf(buf, ZAF_ITEXT("Vlist item %d"), cnt);
		ZafButton *vlistObject = new ZafButton(0, 0, 15, 1, buf);
		vlistObject->SetButtonType(ZAF_FLAT_BUTTON);
		vlistObject->SetHzJustify(ZAF_HZ_LEFT);
		vlist->Add(vlistObject);
	}
	Add(testObject);

	// Add other objects needed to test the object.
	vlist = new ZafVtList(50, 6, 20, 3);
	vlist->Add(new ZafScrollBar(0, 0, 0, 0));
	vlist->SetSelectionType(ZAF_EXTENDED_SELECTION);
	vlist->SetAcceptDrop(true);
	vlist->SetCopyDraggable(true);
	vlist->SetMoveDraggable(true);
	for (cnt = 0; cnt < 10; cnt++)
	{
		ZafIChar buf[32];
		sprintf(buf, ZAF_ITEXT("Drag & drop %d"), cnt);
		ZafButton *vlistObject = new ZafButton(0, 0, 15, 1, buf);
		vlistObject->SetButtonType(ZAF_FLAT_BUTTON);
		vlistObject->SetHzJustify(ZAF_HZ_LEFT);
		vlist->Add(vlistObject);
	}
	Add(vlist);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafVtList *vlist = DynamicPtrCast(testObject, ZafVtList);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_VERTICAL_SCROLL:
		{
			ZafScrollBar *vScroll = vlist->VerticalScrollBar();

			if (!vScroll)
			{
				vScroll = new ZafScrollBar(0, 0, 0, 0);
				vlist->Add(vScroll);
			}
			else
			{
				vlist->Subtract(vScroll);
				delete vScroll;
			}
			attrList->GetObject((ZafNumberID)TST_TOGGLE_VERTICAL_SCROLL)->SetSelected(vlist->VerticalScrollBar() ? true : false);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_ADD_OBJECTS:
		{
			static int newCnt = 1;
			ZafIChar buf[32];
			int addCnt = atoi(GetObject(ZAF_ITEXT("NEW_OBJ_SPIN"))->Text());

			vlist->SetAutomaticUpdate(false);
			for (int cnt = 0; cnt < addCnt; cnt++, newCnt++)
			{
				sprintf(buf, ZAF_ITEXT("New item %d"), newCnt);
				ZafButton *vlistObject = new ZafButton(0, 0, 15, 1, buf);
				vlistObject->SetButtonType(ZAF_FLAT_BUTTON);
				vlistObject->SetHzJustify(ZAF_HZ_LEFT);
				vlist->Add(vlistObject);
			}
			vlist->SetAutomaticUpdate(true);
		}
		break;

	case TST_SET_SORT_NONE:
	case TST_SET_SORT_AUTO:
	case TST_SET_SORT_REVERSE:
		{
			if (ccode == TST_SET_SORT_NONE)
			{
				vlist->SetCompareFunction(ZAF_NULLF(ZafCompareFunction));
				vlist->SetAutoSortData(false);
			}
			else if (ccode == TST_SET_SORT_AUTO)
			{
				vlist->SetAutoSortData(true);
				vlist->Sort();
			}
			else if (ccode == TST_SET_SORT_REVERSE)
			{
				vlist->SetCompareFunction((ZafCompareFunction)CompareDescending);
				vlist->SetAutoSortData(false);
				vlist->Sort();
			}

			ZafComboBox *sortCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("SORT_COMBO")), ZafComboBox);
			if (!vlist->AutoSortData() && !vlist->CompareFunction())
				sortCombo->GetObject((ZafNumberID)TST_SET_SORT_NONE)->SetSelected(true);
			else if (vlist->AutoSortData())
				sortCombo->GetObject((ZafNumberID)TST_SET_SORT_AUTO)->SetSelected(true);
			else if (vlist->CompareFunction() == (ZafCompareFunction)CompareDescending)
				sortCombo->GetObject((ZafNumberID)TST_SET_SORT_REVERSE)->SetSelected(true);
		}
		break;

	case TST_SET_SELECTION_SINGLE:
	case TST_SET_SELECTION_MULTIPLE:
	case TST_SET_SELECTION_EXTENDED:
		{
			if (ccode == TST_SET_SELECTION_SINGLE)
				vlist->SetSelectionType(ZAF_SINGLE_SELECTION);
			else if (ccode == TST_SET_SELECTION_MULTIPLE)
				vlist->SetSelectionType(ZAF_MULTIPLE_SELECTION);
			else if (ccode == TST_SET_SELECTION_EXTENDED)
				vlist->SetSelectionType(ZAF_EXTENDED_SELECTION);

			ZafComboBox *selectionCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("SELECTION_TYPE_COMBO")), ZafComboBox);
			switch (vlist->SelectionType())
			{
			case ZAF_SINGLE_SELECTION:
				selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_SINGLE)->SetSelected(true);
				break;

			case ZAF_MULTIPLE_SELECTION:
				selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_MULTIPLE)->SetSelected(true);
				break;

			case ZAF_EXTENDED_SELECTION:
				selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_EXTENDED)->SetSelected(true);
				break;
			}
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafVtList *vlist = DynamicPtrCast(testObject, ZafVtList);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VERTICAL_SCROLL)->SetSelected(vlist->VerticalScrollBar() ? true : false);

	ZafComboBox *sortCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("SORT_COMBO")), ZafComboBox);
	if (!vlist->AutoSortData() && !vlist->CompareFunction())
		sortCombo->GetObject((ZafNumberID)TST_SET_SORT_NONE)->SetSelected(true);
	else if (vlist->AutoSortData())
		sortCombo->GetObject((ZafNumberID)TST_SET_SORT_AUTO)->SetSelected(true);
	else if (vlist->CompareFunction() == (ZafCompareFunction)CompareDescending)
		sortCombo->GetObject((ZafNumberID)TST_SET_SORT_REVERSE)->SetSelected(true);

	ZafComboBox *selectionCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("SELECTION_TYPE_COMBO")), ZafComboBox);
	switch (vlist->SelectionType())
	{
	case ZAF_SINGLE_SELECTION:
		selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_SINGLE)->SetSelected(true);
		break;

	case ZAF_MULTIPLE_SELECTION:
		selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_MULTIPLE)->SetSelected(true);
		break;

	case ZAF_EXTENDED_SELECTION:
		selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_EXTENDED)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();

}
