//	Zinc Application Framework - STATUS.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
//	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Status bar"));

	GetObject(ZAF_ITEXT("EVENT_LOG"))->SetDisabled(true);

	// Add the test object.
	testObject = GetObject(ZAF_ITEXT("STATUS_BAR"));
	ZafStatusBar *sbar = DynamicPtrCast(testObject, ZafStatusBar);
	ZafTime *time = new ZafTime(50, 0, 15, new ZafTimeData);
	time->SetStringID(ZAF_ITEXT("STATUS_TIME"));
	sbar->Add(time);

	// Add other objects needed to test the object.
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafStatusBar *sbar = DynamicPtrCast(testObject, ZafStatusBar);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		{
			testObject = GetObject(ZAF_ITEXT("STATUS_BAR"));
			GenericTestWin::Event(event);

			// Add a timer so can update progress bars.
			ZafTimer *timer = new ZafTimer(D_ON, 1000);
			timer->Add(this);
			userObject = timer;
			eventManager->Add(timer);
		}
		break;

	case S_DEINITIALIZE:
		{
			ZafTimer *timer = (ZafTimer *)userObject;
			userObject = ZAF_NULLP(void);
			timer->Subtract(this);
			eventManager->Subtract(timer);
			delete timer;
		}
		break;

	case N_TIMER:
		{
			ZafTime *time = DynamicPtrCast(sbar->GetObject(ZAF_ITEXT("STATUS_TIME")), ZafTime);
			time->SetTimeData(new ZafTimeData);
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafStatusBar *sbar = DynamicPtrCast(testObject, ZafStatusBar);

	GenericTestWin::SynchronizeAttributes();
	attrList->GetObject((ZafNumberID)TST_TOGGLE_DISABLED)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_NONCURRENT)->SetDisabled(true);
}
