//	Zinc Application Framework - SPIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafSpinControl
	{ ZAF_ITEXT("View only"),       0, TST_TOGGLE_VIEW_ONLY },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafSpinControl
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafSpinControl(50, 1, 25, new ZafIntegerData(1L))
{
	Add(new ZafInteger(0, 0, 0, new ZafIntegerData(0L)));

	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafSpinControl::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Spin control"));

	// Add settings objects.
	// Create spin object type combo box.
	ZafComboBox *objectTypeCombo = new ZafComboBox(1, 8, 15, 3);
	objectTypeCombo->SetViewOnly(true);
	objectTypeCombo->SetStringID(ZAF_ITEXT("OBJECT_TYPE_COMBO"));
	objectTypeCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Integer"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SPIN_OBJECT_INTEGER);
	attr->SetNumberID((ZafNumberID)TST_SET_SPIN_OBJECT_INTEGER);
	objectTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Date"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SPIN_OBJECT_DATE);
	attr->SetNumberID((ZafNumberID)TST_SET_SPIN_OBJECT_DATE);
	objectTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Time"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SPIN_OBJECT_TIME);
	attr->SetNumberID((ZafNumberID)TST_SET_SPIN_OBJECT_TIME);
	objectTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Real"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SPIN_OBJECT_REAL);
	attr->SetNumberID((ZafNumberID)TST_SET_SPIN_OBJECT_REAL);
	objectTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Bignum"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SPIN_OBJECT_BIGNUM);
	attr->SetNumberID((ZafNumberID)TST_SET_SPIN_OBJECT_BIGNUM);
	objectTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Utime"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SPIN_OBJECT_UTIME);
	attr->SetNumberID((ZafNumberID)TST_SET_SPIN_OBJECT_UTIME);
	objectTypeCombo->Add(attr);

	Add(objectTypeCombo);

	// Add the test object.
	testObject = new TestObj;
	Add(testObject);

	// Add other objects needed to test the object.
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafSpinControl *spin = DynamicPtrCast(testObject, ZafSpinControl);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case TST_SET_SPIN_OBJECT_INTEGER:
	case TST_SET_SPIN_OBJECT_DATE:
	case TST_SET_SPIN_OBJECT_TIME:
	case TST_SET_SPIN_OBJECT_REAL:
	case TST_SET_SPIN_OBJECT_BIGNUM:
	case TST_SET_SPIN_OBJECT_UTIME:
		{
			bool success = false;

			if (ccode == TST_SET_SPIN_OBJECT_INTEGER)
			{
				spin->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(0L)));
				if (spin->First()->IsA(ID_ZAF_INTEGER))
				{
					success = true;
					spin->SetDelta(new ZafIntegerData(1L));
				}
			}
			else if (ccode == TST_SET_SPIN_OBJECT_DATE)
			{
				spin->Add(new ZafDate(0, 0, 0, new ZafDateData));
				if (spin->First()->IsA(ID_ZAF_DATE))
				{
					success = true;
					spin->SetDelta(new ZafDateData(0, 0, 1));
				}
			}
			else if (ccode == TST_SET_SPIN_OBJECT_TIME)
			{
				spin->Add(new ZafTime(0, 0, 0, new ZafTimeData));
				if (spin->First()->IsA(ID_ZAF_TIME))
				{
					success = true;
					spin->SetDelta(new ZafTimeData(0, 1, 0, 0));
				}
			}
			else if (ccode == TST_SET_SPIN_OBJECT_REAL)
			{
				spin->Add(new ZafReal(0, 0, 0, new ZafRealData(0.0)));
				if (spin->First()->IsA(ID_ZAF_REAL))
				{
					success = true;
					spin->SetDelta(new ZafRealData(.1));
				}
			}
			else if (ccode == TST_SET_SPIN_OBJECT_BIGNUM)
			{
				spin->Add(new ZafBignum(0, 0, 0, new ZafBignumData(0.1)));
				if (spin->First()->IsA(ID_ZAF_BIGNUM))
				{
					success = true;
					spin->SetDelta(new ZafBignumData(0.1));
				}
			}
			else if (ccode == TST_SET_SPIN_OBJECT_UTIME)
			{
				spin->Add(new ZafUTime(0, 0, 0, new ZafUTimeData));
				if (spin->First()->IsA(ID_ZAF_UTIME))
				{
					success = true;
					spin->SetDelta(new ZafUTimeData(0, 0, 0, 1, 0, 0, 0));
				}
			}

			// Restore combo box selection if not successful.
			if (!success)
			{
				ZafComboBox *spinCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("OBJECT_TYPE_COMBO")), ZafComboBox);
				switch (spin->First()->ClassID())
				{
				case ID_ZAF_INTEGER:
					spinCombo->GetObject((ZafNumberID)TST_SET_SPIN_OBJECT_INTEGER)->SetSelected(true);
					break;

				case ID_ZAF_DATE:
					spinCombo->GetObject((ZafNumberID)TST_SET_SPIN_OBJECT_DATE)->SetSelected(true);
					break;

				case ID_ZAF_TIME:
					spinCombo->GetObject((ZafNumberID)TST_SET_SPIN_OBJECT_TIME)->SetSelected(true);
					break;

				case ID_ZAF_REAL:
					spinCombo->GetObject((ZafNumberID)TST_SET_SPIN_OBJECT_REAL)->SetSelected(true);
					break;

				case ID_ZAF_BIGNUM:
					spinCombo->GetObject((ZafNumberID)TST_SET_SPIN_OBJECT_BIGNUM)->SetSelected(true);
					break;

				case ID_ZAF_UTIME:
					spinCombo->GetObject((ZafNumberID)TST_SET_SPIN_OBJECT_UTIME)->SetSelected(true);
					break;
				}
			}
		}
		break;

	case TST_TOGGLE_VIEW_ONLY:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY);
			spin->SetViewOnly(attr->Selected());
			attr->SetSelected(spin->ViewOnly());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	GenericTestWin::SynchronizeAttributes();
}
