//	Zinc Application Framework - PROMPT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafPrompt
	{ ZAF_ITEXT("Auto size"),         0, TST_TOGGLE_AUTO_SIZE },
	{ ZAF_ITEXT("Transp. back"),      0, TST_TOGGLE_TRANSPARENT_BACK },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
//	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
//	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

ZafEventType HotKeyStringCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafPrompt *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafPrompt);
		testObject->SetHotKey(*object->Text(), testObject->HotKeyIndex());
		ZafIChar buf[2];
		buf[0] = testObject->HotKeyChar();
		buf[1] = '\0';
		object->SetText(buf);
	}

	return (0);
}

ZafEventType HotKeyIndexCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafPrompt *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafPrompt);
		testObject->SetHotKey(testObject->HotKeyChar(), atoi(object->Text()));
		ZafSpinControl *spin = DynamicPtrCast(object, ZafSpinControl);
		ZafInteger *integer = DynamicPtrCast(spin->Current(), ZafInteger);
		integer->SetIntegerData(new ZafIntegerData(testObject->HotKeyIndex()));
	}

	return (0);
}

// ---- Derived test object -------------------------------------------------

// Derive a test object so can log which events it gets.
class TestObj : public ZafPrompt
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafPrompt(50, 1, 15, new ZafStringData("prompt"))
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));  
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafPrompt::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Prompt"));

	// Add settings objects.
	// Create horizontal justify combo box.
	ZafComboBox *hzJustifyCombo = new ZafComboBox(27, 1, 20, 3);
	hzJustifyCombo->SetViewOnly(true);
	hzJustifyCombo->SetStringID(ZAF_ITEXT("HZ_JUSTIFY_COMBO"));
	hzJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT);
	hzJustifyCombo->Add(attr);

	Add(hzJustifyCombo);

/* START BLOCK COMMENT
**		// Create vertical justify combo box.
**		ZafComboBox *vtJustifyCombo = new ZafComboBox(27, 2, 20, 3);
**		vtJustifyCombo->SetViewOnly(true);
**		vtJustifyCombo->SetStringID(ZAF_ITEXT("VT_JUSTIFY_COMBO"));
**		vtJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
**		attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt top"));
**		attr->SetButtonType(ZAF_FLAT_BUTTON);
**		attr->SetHzJustify(ZAF_HZ_LEFT);
**		attr->SetSendMessageWhenSelected(true);
**		attr->SetValue(TST_SET_VT_JUSTIFY_TOP);
**		attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_TOP);
**		vtJustifyCombo->Add(attr);
**		attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt Center"));
**		attr->SetButtonType(ZAF_FLAT_BUTTON);
**		attr->SetHzJustify(ZAF_HZ_LEFT);
**		attr->SetSendMessageWhenSelected(true);
**		attr->SetValue(TST_SET_VT_JUSTIFY_CENTER);
**		attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER);
**		vtJustifyCombo->Add(attr);
**		attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt Bottom"));
**		attr->SetButtonType(ZAF_FLAT_BUTTON);
**		attr->SetHzJustify(ZAF_HZ_LEFT);
**		attr->SetSendMessageWhenSelected(true);
**		attr->SetValue(TST_SET_VT_JUSTIFY_BOTTOM);
**		attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM);
**		vtJustifyCombo->Add(attr);
**	
**		Add(vtJustifyCombo);
END BLOCK COMMENT */

	Add(new ZafPrompt(1, 8, 10, new ZafStringData("Hotkey char:")));
	ZafString *hotKeyString = new ZafString(13, 8, 3, new ZafStringData("", 1));
	hotKeyString->SetUserFunction(HotKeyStringCallback);
	Add(hotKeyString);

	Add(new ZafPrompt(17, 8, 10, new ZafStringData("Hotkey index:")));
	ZafSpinControl *hotKeyIndex = new ZafSpinControl(29, 8, 8, new ZafIntegerData(1));
	hotKeyIndex->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(-1L)));
	hotKeyIndex->SetUserFunction(HotKeyIndexCallback);
	Add(hotKeyIndex);

	// Add the test object.
	testObject = new TestObj;
	Add(testObject);

	// Add other objects needed to test the object.
	ZafString *string = new ZafString(50, 5, 15, new ZafStringData("Drag & drop"));
	string->SetStringID(ZAF_ITEXT("TEXT_STRING"));
	string->SetAcceptDrop(true);
	string->SetCopyDraggable(true);
	string->SetMoveDraggable(true);
	Add(string);

	ZafButton *textButton = new ZafButton(66, 5, 12, 1, new ZafStringData("New text *"));
	textButton->SetAutoSize(false);
	textButton->SetSendMessageWhenSelected(true);
	textButton->SetValue(TST_SET_TEXT);
	Add(textButton);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafPrompt *prompt = DynamicPtrCast(testObject, ZafPrompt);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_SIZE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SIZE);
			prompt->SetAutoSize(attr->Selected());
			attr->SetSelected(prompt->AutoSize());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_TRANSPARENT_BACK:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_TRANSPARENT_BACK);
			prompt->SetTransparentBackground(attr->Selected());
			attr->SetSelected(prompt->TransparentBackground());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_TEXT:
		prompt->SetText(GetObject(ZAF_ITEXT("TEXT_STRING"))->Text());
		GetObject(ZAF_ITEXT("TEXT_STRING"))->SetText(prompt->Text());
		break;

/* START BLOCK COMMENT
**		case TST_SET_VT_JUSTIFY_TOP:
**		case TST_SET_VT_JUSTIFY_CENTER:
**		case TST_SET_VT_JUSTIFY_BOTTOM:
**			{
**			 	if (ccode == TST_SET_VT_JUSTIFY_TOP)
**					prompt->SetVtJustify(ZAF_VT_TOP);
**			 	else if (ccode == TST_SET_VT_JUSTIFY_CENTER)
**					prompt->SetVtJustify(ZAF_VT_CENTER);
**			 	else if (ccode == TST_SET_VT_JUSTIFY_BOTTOM)
**					prompt->SetVtJustify(ZAF_VT_BOTTOM);
**	
**				ZafComboBox *vtJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VT_JUSTIFY_COMBO")), ZafComboBox);
**				switch (prompt->VtJustify())
**				{
**				case ZAF_VT_TOP:
**					vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_TOP)->SetSelected(true);
**					break;
**	
**				case ZAF_VT_CENTER:
**					vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER)->SetSelected(true);
**					break;
**	
**				case ZAF_VT_BOTTOM:
**					vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM)->SetSelected(true);
**					break;
**				}
**			}
**			break;
END BLOCK COMMENT */

	case TST_SET_HZ_JUSTIFY_LEFT:
	case TST_SET_HZ_JUSTIFY_CENTER:
	case TST_SET_HZ_JUSTIFY_RIGHT:
		{
		 	if (ccode == TST_SET_HZ_JUSTIFY_LEFT)
				prompt->SetHzJustify(ZAF_HZ_LEFT);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_CENTER)
				prompt->SetHzJustify(ZAF_HZ_CENTER);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_RIGHT)
				prompt->SetHzJustify(ZAF_HZ_RIGHT);

			ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
			switch (prompt->HzJustify())
			{
			case ZAF_HZ_LEFT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
				break;

			case ZAF_HZ_CENTER:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_HZ_RIGHT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
				break;
			}
		}

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafPrompt *prompt = DynamicPtrCast(testObject, ZafPrompt);

	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SIZE)->SetSelected(prompt->AutoSize());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_TRANSPARENT_BACK)->SetSelected(prompt->TransparentBackground());

	ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
	switch (prompt->HzJustify())
	{
	case ZAF_HZ_LEFT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
		break;

	case ZAF_HZ_CENTER:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_HZ_RIGHT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
		break;
	}

/* START BLOCK COMMENT
**		ZafComboBox *vtJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VT_JUSTIFY_COMBO")), ZafComboBox);
**		switch (prompt->VtJustify())
**		{
**		case ZAF_VT_TOP:
**			vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_TOP)->SetSelected(true);
**			break;
**	
**		case ZAF_VT_CENTER:
**			vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER)->SetSelected(true);
**			break;
**	
**		case ZAF_VT_BOTTOM:
**			vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM)->SetSelected(true);
**			break;
**		}
END BLOCK COMMENT */

	GenericTestWin::SynchronizeAttributes();

	// Set settings fields disabled.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_NONCURRENT)->SetDisabled(true);
	GetObject(ZAF_ITEXT("HELP_CONTEXT_COMBO"))->SetDisabled(true);
}
