//	Zinc Application Framework - NTBK.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafNotebook

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
//	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

ZafEventType TabHeightCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	ZafNotebook *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafNotebook);
	if (ccode == L_SELECT)
		testObject->SetTabHeight(atoi(object->Text()));
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafSpinControl *spin = DynamicPtrCast(object, ZafSpinControl);
		ZafInteger *integer = DynamicPtrCast(spin->First(), ZafInteger);
		integer->SetIntegerData(new ZafIntegerData(testObject->TabHeight()));
	}

	return (0);
}

ZafEventType TabWidthCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	ZafNotebook *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafNotebook);
	if (ccode == L_SELECT)
		testObject->SetTabWidth(atoi(object->Text()));
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafSpinControl *spin = DynamicPtrCast(object, ZafSpinControl);
		ZafInteger *integer = DynamicPtrCast(spin->First(), ZafInteger);
		integer->SetIntegerData(new ZafIntegerData(testObject->TabWidth()));
	}

	return (0);
}

ZafEventType CurPageCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	ZafNotebook *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafNotebook);
	if (ccode == L_SELECT)
		testObject->SetCurrentPage(atoi(object->Text()));
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafSpinControl *spin = DynamicPtrCast(object, ZafSpinControl);
		ZafInteger *integer = DynamicPtrCast(spin->First(), ZafInteger);
		integer->SetIntegerData(new ZafIntegerData(testObject->CurrentPage()));
	}

	return (0);
}

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafNotebook
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafNotebook(50, 1, 25, 5)
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafNotebook::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Notebook"));

	// Add settings objects.

	Add(new ZafPrompt(27, 1, 10, new ZafStringData("Tab height:")));
	ZafSpinControl *tabHeight = new ZafSpinControl(39, 1, 8, new ZafIntegerData(1));
	tabHeight->SetStringID(ZAF_ITEXT("TAB_HEIGHT_SPIN"));
	tabHeight->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(-1L)));
	tabHeight->SetUserFunction(TabHeightCallback);
	Add(tabHeight);

	Add(new ZafPrompt(27, 2, 10, new ZafStringData("Tab width:")));
	ZafSpinControl *tabWidth = new ZafSpinControl(39, 2, 8, new ZafIntegerData(1));
	tabWidth->SetStringID(ZAF_ITEXT("TAB_WIDTH_SPIN"));
	tabWidth->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(-1L)));
	tabWidth->SetUserFunction(TabWidthCallback);
	Add(tabWidth);

	Add(new ZafPrompt(1, 8, 15, new ZafStringData("# of new objects:")));
	ZafSpinControl *newObjSpin = new ZafSpinControl(18, 8, 8, new ZafIntegerData(1L));
	newObjSpin->SetStringID(ZAF_ITEXT("NEW_OBJ_SPIN"));
	newObjSpin->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(0L)));
	Add(newObjSpin);
	ZafButton *newObjButton = new ZafButton(27, 8, 10, 1, new ZafStringData("Add** ->"));
	newObjButton->SetAutoSize(false);
	newObjButton->SetValue(TST_ADD_OBJECTS);
	newObjButton->SetSendMessageWhenSelected(true);
	Add(newObjButton);

	Add(new ZafPrompt(1, 9, 15, new ZafStringData("Current page:*")));
	ZafSpinControl *curPage = new ZafSpinControl(16, 9, 8, new ZafIntegerData(1));
	curPage->SetStringID(ZAF_ITEXT("CURRENT_PAGE_SPIN"));
	curPage->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(-1L)));
	curPage->SetUserFunction(CurPageCallback);
	Add(curPage);

	ZafString *tabText = new ZafString(27, 9, 10, new ZafStringData("", 32));
	tabText->SetStringID(ZAF_ITEXT("TAB_TEXT_STRING"));
	Add(tabText);
	ZafButton *tabTextApply = new ZafButton(38, 9, 10, 1, new ZafStringData("Apply* ->"));
	tabTextApply->SetAutoSize(false);
	tabTextApply->SetValue(TST_SET_TAB_TEXT);
	tabTextApply->SetSendMessageWhenSelected(true);
	Add(tabTextApply);

	// Add the test object.
	testObject = new TestObj;
	ZafNotebook *nbook = DynamicPtrCast(testObject, ZafNotebook);
	nbook->SetRegionType(ZAF_INSIDE_REGION);
	ZafIChar buf[32];
	for (int cnt = 1; cnt <= 5; cnt++)
	{
	 	sprintf(buf, ZAF_ITEXT("Page %d"), cnt);
		ZafWindow *newPage = new ZafWindow(0, 0, 50, 3);
		newPage->Add(new ZafTitle(new ZafStringData(buf)));
		sprintf(buf, ZAF_ITEXT("Button %d"), cnt);
		newPage->Add(new ZafButton(1, 2, 10, 1, new ZafStringData(buf)));
		nbook->Add(newPage);
	}	

	Add(testObject);

	// Add other objects needed to test the object.
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafNotebook *nbook = DynamicPtrCast(testObject, ZafNotebook);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.

	case TST_ADD_OBJECTS:
		{
			static int newCnt = 1;
			ZafIChar buf[32];
			int addCnt = atoi(GetObject(ZAF_ITEXT("NEW_OBJ_SPIN"))->Text());

			for (int cnt = 0; cnt < addCnt; cnt++, newCnt++)
			{
				sprintf(buf, ZAF_ITEXT("New item %d"), newCnt);
				ZafWindow *newPage = new ZafWindow(0, 0, 50, 3);
				newPage->Add(new ZafTitle(new ZafStringData(buf)));
				sprintf(buf, ZAF_ITEXT("New Button %d"), newCnt);
				newPage->Add(new ZafButton(1, 2, 15, 1, new ZafStringData(buf)));
				nbook->Add(newPage);
			}
		}
		break;

	case TST_SET_TAB_TEXT:
	{
		nbook->SetTabText(GetObject(ZAF_ITEXT("TAB_TEXT_STRING"))->Text(), nbook->CurrentPage());
		GetObject(ZAF_ITEXT("TAB_TEXT_STRING"))->SetText(nbook->TabText(nbook->CurrentPage()));
	}
	break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafNotebook *nbook = DynamicPtrCast(testObject, ZafNotebook);

	ZafSpinControl *spin = DynamicPtrCast(GetObject(ZAF_ITEXT("TAB_HEIGHT_SPIN")), ZafSpinControl);
	ZafInteger *integer = DynamicPtrCast(spin->First(), ZafInteger);
	integer->SetIntegerData(new ZafIntegerData(nbook->TabHeight()));

	spin = DynamicPtrCast(GetObject(ZAF_ITEXT("TAB_WIDTH_SPIN")), ZafSpinControl);
	integer = DynamicPtrCast(spin->First(), ZafInteger);
	integer->SetIntegerData(new ZafIntegerData(nbook->TabWidth()));

	spin = DynamicPtrCast(GetObject(ZAF_ITEXT("CURRENT_PAGE_SPIN")), ZafSpinControl);
	integer = DynamicPtrCast(spin->First(), ZafInteger);
	integer->SetIntegerData(new ZafIntegerData(nbook->CurrentPage()));

	GenericTestWin::SynchronizeAttributes();
}
