//	Zinc Application Framework - ICON.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafIcon
	{ ZAF_ITEXT("Auto size"),         0, TST_TOGGLE_AUTO_SIZE },
	{ ZAF_ITEXT("Allow toggle"),      0, TST_TOGGLE_ALLOW_TOGGLE },
	{ ZAF_ITEXT("Auto repeat"),       0, TST_TOGGLE_AUTO_REPEAT },
	{ ZAF_ITEXT("Double click"),      0, TST_TOGGLE_DOUBLE_CLICK },
	{ ZAF_ITEXT("Down click"),        0, TST_TOGGLE_DOWN_CLICK },
	{ ZAF_ITEXT("Send message"),      0, TST_TOGGLE_SEND_MESSAGE },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
//	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

static ZafLogicalColor iconArray1[32][32] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
};

static ZafIconStruct iconInfo1(32, 32, (ZafLogicalColor *)iconArray1, true);
static ZafIconData iconData1(iconInfo1);

// ---- Derived test object -------------------------------------------------

// Derive a test object so can log which events it gets.
class TestObj : public ZafIcon
{
public:
  	TestObj(void);
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj(void) :
	ZafIcon(50, 1, new ZafStringData("icon"), new ZafIconData(iconData1))
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	switch (ccode)
	{
	case TST_SET_ICON_IMAGE_APP:
	case TST_SET_ICON_IMAGE_ASTERISK:
	case TST_SET_ICON_IMAGE_EXCLAMATION:
	case TST_SET_ICON_IMAGE_HAND:
	case TST_SET_ICON_IMAGE_QUESTION:
		SetIconData(imageTable[ccode - TST_SET_ICON_IMAGE_APP]);
		break;

	case S_CURRENT:
	case S_NON_CURRENT:
		{
		ccode = ZafIcon::Event(event);
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
		}
		break;

	default:
		ccode = ZafIcon::Event(event);
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Icon"));

	// Add settings objects.
	// Create horizontal justify combo box.
	ZafComboBox *hzJustifyCombo = new ZafComboBox(27, 1, 20, 3);
	hzJustifyCombo->SetViewOnly(true);
	hzJustifyCombo->SetStringID(ZAF_ITEXT("HZ_JUSTIFY_COMBO"));
	hzJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT);
	hzJustifyCombo->Add(attr);

	Add(hzJustifyCombo);

	// Create vertical justify combo box.
	ZafComboBox *vtJustifyCombo = new ZafComboBox(27, 2, 20, 3);
	vtJustifyCombo->SetViewOnly(true);
	vtJustifyCombo->SetStringID(ZAF_ITEXT("VT_JUSTIFY_COMBO"));
	vtJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt top"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VT_JUSTIFY_TOP);
	attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_TOP);
	vtJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt Center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VT_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER);
	vtJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt Bottom"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VT_JUSTIFY_BOTTOM);
	attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM);
	vtJustifyCombo->Add(attr);

	Add(vtJustifyCombo);

	// Create image combo box.
	Add(new ZafPrompt(1, 8, 5, new ZafStringData("Image: *")));
	ZafComboBox *imageCombo = new ZafComboBox(9, 8, 13, 3);
	imageCombo->SetViewOnly(true);
	imageCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("None"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_ICON_IMAGE_NONE);
	imageCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Application"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_ICON_IMAGE_APP);
	imageCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Asterisk"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_ICON_IMAGE_ASTERISK);
	imageCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Exclamation"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_ICON_IMAGE_EXCLAMATION);
	imageCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hand"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_ICON_IMAGE_HAND);
	imageCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Question"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_ICON_IMAGE_QUESTION);
	imageCombo->Add(attr);

	Add(imageCombo);

	// Create value combo box.
	Add(new ZafPrompt(23, 8, 7, new ZafStringData("Value: *")));
	ZafComboBox *valueCombo = new ZafComboBox(31, 8, 12, 3);
	valueCombo->SetStringID(ZAF_ITEXT("VALUE_COMBO"));
	valueCombo->SetViewOnly(true);
	valueCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("None"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VALUE_NONE);
	attr->SetNumberID((ZafNumberID)TST_SET_VALUE_NONE);
	valueCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Beep"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VALUE_BEEP);
	attr->SetNumberID((ZafNumberID)TST_SET_VALUE_BEEP);
	valueCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Redisplay"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VALUE_REDISPLAY);
	attr->SetNumberID((ZafNumberID)TST_SET_VALUE_REDISPLAY);
	valueCombo->Add(attr);

	Add(valueCombo);

	// Add the test object.
	testObject = new TestObj;
	Add(testObject);

	// Add other objects needed to test the object.
	ZafIcon *icon = new ZafIcon(50, 4, new ZafStringData("Drag & drop"), new ZafIconData(iconData1));
	icon->SetAcceptDrop(true);
	icon->SetCopyDraggable(true);
	icon->SetMoveDraggable(true);
	Add(icon);

	ZafString *string = new ZafString(50, 7, 15, new ZafStringData("Drag & drop"));
	string->SetAcceptDrop(true);
	string->SetCopyDraggable(true);
	string->SetMoveDraggable(true);
	Add(string);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafIcon *icon = DynamicPtrCast(testObject, ZafIcon);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_SIZE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SIZE);
			icon->SetAutoSize(attr->Selected());
			attr->SetSelected(icon->AutoSize());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_ALLOW_TOGGLE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_ALLOW_TOGGLE);
			icon->SetAllowToggling(attr->Selected());
			attr->SetSelected(icon->AllowToggling());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_AUTO_REPEAT:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_REPEAT);
			icon->SetAutoRepeatSelection(attr->Selected());
			attr->SetSelected(icon->AutoRepeatSelection());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_SELECTED:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTED);
			icon->SetSelected(attr->Selected());
			attr->SetSelected(icon->Selected());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_DOUBLE_CLICK:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_DOUBLE_CLICK);
			icon->SetSelectOnDoubleClick(attr->Selected());
			attr->SetSelected(icon->SelectOnDoubleClick());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_DOWN_CLICK:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_DOWN_CLICK);
			icon->SetSelectOnDownClick(attr->Selected());
			attr->SetSelected(icon->SelectOnDownClick());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_SEND_MESSAGE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_SEND_MESSAGE);
			icon->SetSendMessageWhenSelected(attr->Selected());
			attr->SetSelected(icon->SendMessageWhenSelected());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_ICON_IMAGE_NONE:
		icon->ClearImage();
		break;

	case TST_SET_ICON_IMAGE_APP:
	case TST_SET_ICON_IMAGE_ASTERISK:
	case TST_SET_ICON_IMAGE_EXCLAMATION:
	case TST_SET_ICON_IMAGE_HAND:
	case TST_SET_ICON_IMAGE_QUESTION:
		icon->Event(event);
		break;

	case TST_SET_VALUE_NONE:
	case TST_SET_VALUE_BEEP:
	case TST_SET_VALUE_REDISPLAY:
		{
			if (ccode == TST_SET_VALUE_NONE)
				icon->SetValue(0);
			else if (ccode == TST_SET_VALUE_BEEP)
				icon->SetValue(TST_BEEP);
		 	else if (ccode == TST_SET_VALUE_REDISPLAY)
				icon->SetValue(TST_REDRAW);

			ZafComboBox *valueCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VALUE_COMBO")), ZafComboBox);
			switch (icon->Value())
			{
			case TST_SET_VALUE_NONE:
				valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_NONE)->SetSelected(true);
				break;

			case TST_SET_VALUE_BEEP:
				valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_BEEP)->SetSelected(true);
				break;

			case TST_SET_VALUE_REDISPLAY:
				valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_REDISPLAY)->SetSelected(true);
				break;
			}
		}
		break;

	case TST_BEEP:
		ZafErrorSystem::Beep();
		break;

	case TST_SET_VT_JUSTIFY_TOP:
	case TST_SET_VT_JUSTIFY_CENTER:
	case TST_SET_VT_JUSTIFY_BOTTOM:
		{
		 	if (ccode == TST_SET_VT_JUSTIFY_TOP)
				icon->SetVtJustify(ZAF_VT_TOP);
		 	else if (ccode == TST_SET_VT_JUSTIFY_CENTER)
				icon->SetVtJustify(ZAF_VT_CENTER);
		 	else if (ccode == TST_SET_VT_JUSTIFY_BOTTOM)
				icon->SetVtJustify(ZAF_VT_BOTTOM);

			ZafComboBox *vtJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VT_JUSTIFY_COMBO")), ZafComboBox);
			switch (icon->VtJustify())
			{
			case ZAF_VT_TOP:
				vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_TOP)->SetSelected(true);
				break;

			case ZAF_VT_CENTER:
				vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_VT_BOTTOM:
				vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM)->SetSelected(true);
				break;
			}
		}
		break;

	case TST_SET_HZ_JUSTIFY_LEFT:
	case TST_SET_HZ_JUSTIFY_CENTER:
	case TST_SET_HZ_JUSTIFY_RIGHT:
		{
		 	if (ccode == TST_SET_HZ_JUSTIFY_LEFT)
				icon->SetHzJustify(ZAF_HZ_LEFT);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_CENTER)
				icon->SetHzJustify(ZAF_HZ_CENTER);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_RIGHT)
				icon->SetHzJustify(ZAF_HZ_RIGHT);

			ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
			switch (icon->HzJustify())
			{
			case ZAF_HZ_LEFT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
				break;

			case ZAF_HZ_CENTER:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_HZ_RIGHT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
				break;
			}
		}

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafIcon *icon = DynamicPtrCast(testObject, ZafIcon);

	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SIZE)->SetSelected(icon->AutoSize());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_ALLOW_TOGGLE)->SetSelected(icon->AllowToggling());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_REPEAT)->SetSelected(icon->AutoRepeatSelection());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_DOUBLE_CLICK)->SetSelected(icon->SelectOnDoubleClick());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_DOWN_CLICK)->SetSelected(icon->SelectOnDownClick());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_SEND_MESSAGE)->SetSelected(icon->SendMessageWhenSelected());

	ZafComboBox *valueCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VALUE_COMBO")), ZafComboBox);
	switch (icon->Value())
	{
	case TST_SET_VALUE_NONE:
		valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_NONE)->SetSelected(true);
		break;

	case TST_SET_VALUE_BEEP:
		valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_BEEP)->SetSelected(true);
		break;

	case TST_SET_VALUE_REDISPLAY:
		valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_REDISPLAY)->SetSelected(true);
		break;
	}

	ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
	switch (icon->HzJustify())
	{
	case ZAF_HZ_LEFT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
		break;

	case ZAF_HZ_CENTER:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_HZ_RIGHT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
		break;
	}

	ZafComboBox *vtJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VT_JUSTIFY_COMBO")), ZafComboBox);
	switch (icon->VtJustify())
	{
	case ZAF_VT_TOP:
		vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_TOP)->SetSelected(true);
		break;

	case ZAF_VT_CENTER:
		vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_VT_BOTTOM:
		vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();

	// Set settings fields disabled.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_ALLOW_TOGGLE)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_REPEAT)->SetDisabled(true);
}
