//	Zinc Application Framework - FSTR.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafFormattedString
	{ ZAF_ITEXT("Auto clear *"),      0, TST_TOGGLE_AUTO_CLEAR },
	{ ZAF_ITEXT("Invalid *"),         0, TST_TOGGLE_INVALID },
	{ ZAF_ITEXT("Lower case"),        0, TST_TOGGLE_LOWERCASE },
	{ ZAF_ITEXT("Password"),          0, TST_TOGGLE_PASSWORD },
	{ ZAF_ITEXT("Unanswered *"),      0, TST_TOGGLE_UNANSWERED },
	{ ZAF_ITEXT("Upper case"),        0, TST_TOGGLE_UPPERCASE },
	{ ZAF_ITEXT("Variable name"),     0, TST_TOGGLE_VARIABLENAME },
	{ ZAF_ITEXT("View only"),         0, TST_TOGGLE_VIEW_ONLY },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),         0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafFormattedString
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() :
	ZafFormattedString(50, 1, 18, new ZafStringData("8017858900"),
		new ZafStringData("LNNNLLNNNLNNNN"), new ZafStringData("(...) ...-...."))

{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafFormattedString::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Add testing fields.
	// Create horizontal justify combo box.
	ZafComboBox *hzJustifyCombo = new ZafComboBox(27, 1, 20, 3);
	hzJustifyCombo->SetViewOnly(true);
	hzJustifyCombo->SetStringID(ZAF_ITEXT("HZ_JUSTIFY_COMBO"));
	hzJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT);
	hzJustifyCombo->Add(attr);

	Add(hzJustifyCombo);

	Add(new ZafPrompt(1, 8, 8, new ZafStringData("Delete:")));
	ZafString *deleteString = new ZafString(9, 8, 18, new ZafStringData("", 32));
	deleteString->SetStringID(ZAF_ITEXT("DELETE_TEXT"));
	Add(deleteString);
	ZafButton *deleteButton = new ZafButton(28, 8, 7, 1, new ZafStringData("Apply"));
	deleteButton->SetSendMessageWhenSelected(true);
	deleteButton->SetValue(TST_SET_DELETE_TEXT);
	deleteButton->SetAutoSize(false);
	Add(deleteButton);

	Add(new ZafPrompt(1, 9, 8, new ZafStringData("Format:")));
	ZafString *formatString = new ZafString(9, 9, 18, new ZafStringData("", 32));
	formatString->SetStringID(ZAF_ITEXT("FORMAT_TEXT"));
	Add(formatString);
	ZafButton *formatButton = new ZafButton(28, 9, 7, 1, new ZafStringData("Apply"));
	formatButton->SetSendMessageWhenSelected(true);
	formatButton->SetValue(TST_SET_FORMAT_TEXT);
	formatButton->SetAutoSize(false);
	Add(formatButton);

	// Set the title text.
	SetText(ZAF_ITEXT("Formatted String"));

	// Add the test object.
	testObject = new TestObj;
//	DynamicPtrCast(testObject, ZafFormattedString)->SetStringData(sharedData);
	Add(testObject);

	// Add other objects needed to test the object.

	ZafString * string = new ZafString(50, 5, 18, new ZafStringData("Drag & drop", 32));
	string->SetAcceptDrop(true);
	string->SetCopyDraggable(true);
	string->SetMoveDraggable(true);
	Add(string);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafFormattedString *fString = DynamicPtrCast(testObject, ZafFormattedString);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_CLEAR:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR);
			fString->SetAutoClear(attr->Selected());
			attr->SetSelected(fString->AutoClear());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_INVALID:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID);
			fString->SetInvalid(attr->Selected());
			attr->SetSelected(fString->Invalid());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_LOWERCASE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE);
			fString->SetLowerCase(attr->Selected());
			attr->SetSelected(fString->LowerCase());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_PASSWORD:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD);
			fString->SetPassword(attr->Selected());
			attr->SetSelected(fString->Password());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UNANSWERED:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED);
			fString->SetUnanswered(attr->Selected());
			attr->SetSelected(fString->Unanswered());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UPPERCASE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE);
			fString->SetUpperCase(attr->Selected());
			attr->SetSelected(fString->UpperCase());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VARIABLENAME:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME);
			fString->SetVariableName(attr->Selected());
			attr->SetSelected(fString->VariableName());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VIEW_ONLY:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY);
			fString->SetViewOnly(attr->Selected());
			attr->SetSelected(fString->ViewOnly());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_HZ_JUSTIFY_LEFT:
	case TST_SET_HZ_JUSTIFY_CENTER:
	case TST_SET_HZ_JUSTIFY_RIGHT:
		{
		 	if (ccode == TST_SET_HZ_JUSTIFY_LEFT)
				fString->SetHzJustify(ZAF_HZ_LEFT);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_CENTER)
				fString->SetHzJustify(ZAF_HZ_CENTER);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_RIGHT)
				fString->SetHzJustify(ZAF_HZ_RIGHT);

			ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
			switch (fString->HzJustify())
			{
			case ZAF_HZ_LEFT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
				break;

			case ZAF_HZ_CENTER:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_HZ_RIGHT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
				break;
			}
		}
		break;

	case TST_SET_DELETE_TEXT:
		fString->SetDeleteText(GetObject(ZAF_ITEXT("DELETE_TEXT"))->Text());
		GetObject(ZAF_ITEXT("DELETE_TEXT"))->SetText(fString->DeleteData()->Text());
		break;

	case TST_SET_FORMAT_TEXT:
		fString->SetInputFormat(GetObject(ZAF_ITEXT("FORMAT_TEXT"))->Text());
		GetObject(ZAF_ITEXT("FORMAT_TEXT"))->SetText(fString->InputFormatData()->Text());
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafFormattedString *fString = DynamicPtrCast(testObject, ZafFormattedString);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR)->SetSelected(fString->AutoClear());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID)->SetSelected(fString->Invalid());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE)->SetSelected(fString->LowerCase());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD)->SetSelected(fString->Password());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED)->SetSelected(fString->Unanswered());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE)->SetSelected(fString->UpperCase());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME)->SetSelected(fString->VariableName());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY)->SetSelected(fString->ViewOnly());
	GetObject(ZAF_ITEXT("DELETE_TEXT"))->SetText(fString->DeleteData()->Text());
	GetObject(ZAF_ITEXT("FORMAT_TEXT"))->SetText(fString->InputFormatData()->Text());

	ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
	switch (fString->HzJustify())
	{
	case ZAF_HZ_LEFT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
		break;

	case ZAF_HZ_CENTER:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_HZ_RIGHT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();

	// Set settings fields disabled.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME)->SetDisabled(true);
}
