//	Zinc Application Framework - FORMAT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "format.hpp"

FormatString::FormatString(int left, int top, int width, ZafStringData *_formatData) :
	ZafString(left, top, width, ZAF_NULLP(ZafStringData)), formatData(_formatData)
{
	ZafStringData *stringData = new ZafStringData(ZAF_ITEXT(""), 256);
	FormatDataToStringData(formatData, stringData);
	SetStringData(stringData);
}

ZafEventType FormatString::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = LogicalEvent(event);
	switch (ccode)
	{
	case L_SELECT:
	case S_NON_CURRENT:
		ccode = ZafString::Event(event);
		StringDataToFormatData(stringData, formatData);
		break;

	default:
		ccode = ZafString::Event(event);
	}

	return ccode;
}

void FormatString::FormatDataToStringData(ZafStringData *formatData, ZafStringData *stringData)
{
	ZafIChar convertBuffer[512];
	ZafIChar tempBuffer[512];
	strcpy(convertBuffer, formatData->Text());
	ZafIChar *str = convertBuffer;
	while (*str)
	{
		if (*str == '\n')
		{
			strcpy(tempBuffer, str + 1);
			*str++ = '\\';
			*str++ = 'n';
			strcpy(str, tempBuffer);
		}
		else
			str++;
	}
	stringData->SetText(convertBuffer);
}

void FormatString::StringDataToFormatData(ZafStringData *stringData, ZafStringData *formatData)
{
	ZafIChar convertBuffer[512];
	ZafIChar tempBuffer[512];
	strcpy(convertBuffer, stringData->Text());
	ZafIChar *str = convertBuffer;
	while (*str)
	{
		if (strncmp(str, ZAF_ITEXT("\\n"), 2) == 0)
		{
			strcpy(tempBuffer, str + 2);
			*str++ = '\n';
			strcpy(str, tempBuffer);
		}
		else
			str++;
	}
	formatData->SetText(convertBuffer);
}
