//	Zinc Application Framework - DATE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"
#include "format.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafDate
	{ ZAF_ITEXT("Auto clear *"),      0, TST_TOGGLE_AUTO_CLEAR },
	{ ZAF_ITEXT("Invalid *"),         0, TST_TOGGLE_INVALID },
	{ ZAF_ITEXT("Lower case"),        0, TST_TOGGLE_LOWERCASE },
	{ ZAF_ITEXT("Password"),          0, TST_TOGGLE_PASSWORD },
	{ ZAF_ITEXT("Unanswered *"),      0, TST_TOGGLE_UNANSWERED },
	{ ZAF_ITEXT("Upper case"),        0, TST_TOGGLE_UPPERCASE },
	{ ZAF_ITEXT("Variable name"),     0, TST_TOGGLE_VARIABLENAME },
	{ ZAF_ITEXT("View only"),         0, TST_TOGGLE_VIEW_ONLY },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),         0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafDate
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafDate(50, 1, 15, ZAF_NULLP(ZafDateData))
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafDate::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 11)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	ZafDateData *sharedData = new ZafDateData;

	// Set the title text.
	SetText(ZAF_ITEXT("Date"));

	ZafStringData *inputFormatData = new ZafStringData(zafLocale->dateStringInputFormat, 256);
	ZafStringData *outputFormatData = new ZafStringData(zafLocale->dateStringOutputFormat, 64);

	// Create horizontal justify combo box.
	ZafComboBox *hzJustifyCombo = new ZafComboBox(27, 1, 20, 3);
	hzJustifyCombo->SetViewOnly(true);
	hzJustifyCombo->SetStringID(ZAF_ITEXT("HZ_JUSTIFY_COMBO"));
	hzJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT);
	hzJustifyCombo->Add(attr);

	Add(hzJustifyCombo);

	// Add the test object.
	testObject = new TestObj;
	DynamicPtrCast(testObject, ZafDate)->SetDateData(sharedData);
	DynamicPtrCast(testObject, ZafDate)->SetInputFormatData(inputFormatData);
	DynamicPtrCast(testObject, ZafDate)->SetOutputFormatData(outputFormatData);
	Add(testObject);

	// Add other objects needed to test the object.
	ZafDate *date = new ZafDate(50, 2, 15, sharedData);
	date->SetAcceptDrop(true);
	date->SetCopyDraggable(true);
	date->SetMoveDraggable(true);
	Add(date);

	date = new ZafDate(50, 5, 15, new ZafDateData);
	date->SetAcceptDrop(true);
	date->SetCopyDraggable(true);
	date->SetMoveDraggable(true);
	Add(date);

	ZafPrompt *prompt = new ZafPrompt(0, 8, 16, new ZafStringData("Input Format:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	FormatString *formatString = new FormatString(17, 8, 25, inputFormatData);
	Add(formatString);

	prompt = new ZafPrompt(0, 9, 16, new ZafStringData("Output Format:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	formatString = new FormatString(17, 9, 25, outputFormatData);
	Add(formatString);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafDate *date = DynamicPtrCast(testObject, ZafDate);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_CLEAR:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR);
			date->SetAutoClear(attr->Selected());
			attr->SetSelected(date->AutoClear());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_INVALID:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID);
			date->SetInvalid(attr->Selected());
			attr->SetSelected(date->Invalid());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_LOWERCASE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE);
			date->SetLowerCase(attr->Selected());
			attr->SetSelected(date->LowerCase());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_PASSWORD:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD);
			date->SetPassword(attr->Selected());
			attr->SetSelected(date->Password());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UNANSWERED:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED);
			date->SetUnanswered(attr->Selected());
			attr->SetSelected(date->Unanswered());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UPPERCASE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE);
			date->SetUpperCase(attr->Selected());
			attr->SetSelected(date->UpperCase());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VARIABLENAME:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME);
			date->SetVariableName(attr->Selected());
			attr->SetSelected(date->VariableName());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VIEW_ONLY:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY);
			date->SetViewOnly(attr->Selected());
			attr->SetSelected(date->ViewOnly());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_HZ_JUSTIFY_LEFT:
	case TST_SET_HZ_JUSTIFY_CENTER:
	case TST_SET_HZ_JUSTIFY_RIGHT:
		{
		 	if (ccode == TST_SET_HZ_JUSTIFY_LEFT)
				date->SetHzJustify(ZAF_HZ_LEFT);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_CENTER)
				date->SetHzJustify(ZAF_HZ_CENTER);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_RIGHT)
				date->SetHzJustify(ZAF_HZ_RIGHT);

			ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
			switch (date->HzJustify())
			{
			case ZAF_HZ_LEFT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
				break;

			case ZAF_HZ_CENTER:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_HZ_RIGHT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
				break;
			}
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafDate *date = DynamicPtrCast(testObject, ZafDate);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR)->SetSelected(date->AutoClear());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID)->SetSelected(date->Invalid());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE)->SetSelected(date->LowerCase());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD)->SetSelected(date->Password());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED)->SetSelected(date->Unanswered());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE)->SetSelected(date->UpperCase());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME)->SetSelected(date->VariableName());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY)->SetSelected(date->ViewOnly());

	ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
	switch (date->HzJustify())
	{
	case ZAF_HZ_LEFT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
		break;

	case ZAF_HZ_CENTER:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_HZ_RIGHT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();

	// Set settings fields disabled.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME)->SetDisabled(true);
}
