//	Zinc Application Framework - Z_VLIST.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_VLIST_HPP)
#define Z_VLIST_HPP
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafVtList ----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafVtList : public ZafWindow
{
public:
	// --- General members ---
	ZafVtList(int left, int top, int width, int height);
	ZafVtList(const ZafVtList &copy);
	virtual ~ZafVtList(void);

	// --- Persistent members ---
	ZafVtList(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	bool AutoSortData(void) const;
	// set
	virtual bool SetAutoSortData(bool autoSortData);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual bool SetSizeable(bool sizeable);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);
	virtual bool CopyDraggable(void) const;
	virtual bool Draggable(void) const;
	virtual void GetClip(ZafWindowObject *object, ZafRegionStruct &clip, ZafRegionStruct &virtualRegion);
	virtual bool LinkDraggable(void) const;
	virtual bool MoveDraggable(void) const;
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);
	virtual bool SetAutomaticUpdate(bool automaticUpdate);
	virtual ZafLogicalColor SetBackgroundColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual ZafLogicalFont SetFont(ZafLogicalFont font);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual ZafLogicalColor SetTextColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual bool SetVisible(bool visible);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	virtual void Destroy(void);
	virtual void Sort(void);
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);

	ZafVtList &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafVtList &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const
		{ return ((compareID == classID || compareID == ID_ZAF_LIST) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const
		{ return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

protected:
	friend class ZAF_EXPORT OSVtList;
	friend class ZAF_EXPORT ZafComboBox;

	bool autoSortData;

	// --- General members ---
	virtual ZafRegionStruct ConvertToDrawRegion(const ZafWindowObject *object,
		const ZafRegionStruct *zafRegion = ZAF_NULLP(ZafRegionStruct)) const;
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType DragDropEvent(const ZafEventStruct &event);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType DrawFocus(ZafRegionStruct &region, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);
	virtual ZafEventType MoveEvent(const ZafEventStruct &event);
	virtual ZafWindowObject *NotifyFocus(ZafWindowObject *object, bool focus);
	virtual ZafWindowObject *NotifySelection(ZafWindowObject *object, bool selected);
	virtual ZafEventType ScrollEvent(const ZafEventStruct &event);

	// --- Special OS members ---
	virtual void OSDestroy(void);
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSSize(void);
	virtual void OSSort(void);
	virtual void OSRegisterObject(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafVtList::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafEventMap ZAF_FARDATA defaultEventMap[];

#	if defined(ZAF_MOTIF)
	int itemWidth, itemHeight;
	ZafWindowObject *firstVisible, *lastVisible, *cancelObject;
	void ComputeNextPosition(ZafWindowObject *object, int &line);
	void ComputePreviousPosition(ZafWindowObject *object, int &line);
#	elif defined(ZAF_MSDOS) || defined(ZAF_CURSES)
	ZafWindowObject *firstVisible, *lastVisible;
#	endif
};

// --- inline functions ---
inline bool ZafVtList::AutoSortData(void) const { return (autoSortData); }
inline bool ZafVtList::CopyDraggable(void) const { return ((temporary && parent) ? parent->CopyDraggable() : copyDraggable); }
inline bool ZafVtList::Draggable(void) const { return ((temporary && parent) ? parent->Draggable() : (copyDraggable || moveDraggable || linkDraggable)); }
inline bool ZafVtList::LinkDraggable(void) const { return ((temporary && parent) ? parent->LinkDraggable() : linkDraggable); }
inline bool ZafVtList::MoveDraggable(void) const { return ((temporary && parent) ? parent->MoveDraggable() : moveDraggable); }

#endif // Z_VLIST_HPP

