//	Zinc Application Framework - Z_UTIME1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_UTIME1_HPP)
#define Z_UTIME1_HPP
#include <z_utime.hpp>
#include <z_str1.hpp>
#include <z_lang.hpp>
#include <z_loc.hpp>

// --------------------------------------------------------------------------
// ----- ZafUTime -----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafUTime : public ZafString
{
public:
	// --- General members ---
	ZafUTime(int left, int top, int width,
		ZafUTimeData *utimeData = ZAF_NULLP(ZafUTimeData));
	ZafUTime(int left, int top, int width,
		int year, int month, int day, int hour, int minute, int second, int milliSecond = 0);
	ZafUTime(const ZafUTime &copy);
	virtual ~ZafUTime(void);

	// --- Persistent members ---
	ZafUTime(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafUTimeData *UTimeData(void) const;
	// set
	virtual ZafError SetUTimeData(ZafUTimeData *utime);

	// --- String members ---
	virtual bool SetLowerCase(bool lowerCase);
	virtual bool SetPassword(bool password);
	virtual ZafError SetStringData(ZafStringData *string);
	virtual bool SetUpperCase(bool upperCase);
	virtual bool SetVariableName(bool variableName);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafError SetText(const ZafIChar *text);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafString::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafString::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSUTime;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);

	// --- Data access ---
	ZafUTimeData *utimeData;
	virtual ZafError Decrement(ZafData *data);
	virtual ZafError Increment(ZafData *data);
	static ZafError Update(ZafUTime *utime, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return utime->OSSetUTime();
		  else if (type == ZAF_UPDATE_DATA) return utime->OSGetUTime();
		  else return (ZAF_ERROR_INVALID); }
	virtual ZafError Validate(bool processError = true);

	// --- Special OS members ---
	ZafError OSGetUTime(void);
	ZafError OSSetUTime(void);

	// --- Language & locale support ---
	static ZafLanguageData *errorStrings;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafUTime::Read); }
	void WriteData(ZafObjectPersistence &persist);
};

// --- inline functions ---
inline ZafUTimeData *ZafUTime::UTimeData(void) const { return utimeData; }
inline ZafError ZafUTime::SetText(const ZafIChar *text) { return (utimeData->SetUTime(text, inputFormatData ? inputFormatData->Text() : ZAF_NULLP(ZafIChar))); }

#endif // Z_UTIME1_HPP

