//	Zinc Application Framework - Z_UTILS.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_UTILS_HPP)
#define Z_UTILS_HPP
#include <z_env.hpp>

#if defined(ZAF_ISO8859_1)
#	if defined(__BORLANDC__)
#		include <z_string.hpp>
#	endif
ZAF_EXPORT ZafIChar *Strdup(const ZafIChar *srcString);
ZAF_EXPORT int Stricmp(const ZafIChar *a, const ZafIChar *b);
ZAF_EXPORT ZafIChar *Strlwr(ZafIChar *string);
ZAF_EXPORT ZafIChar *Strupr(ZafIChar *string);
#	define OSstrdup		strdup
#	define OSstricmp	stricmp
#	define OSstrlwr		strlwr
#	define OSstrupr		strupr
#	define strdup		Strdup
#	define stricmp		Stricmp
#	define strlwr		Strlwr
#	define strupr		Strupr
#elif defined(ZAF_UNICODE)
#	define strdup		Strdup
#	define stricmp		Stricmp
#	define strlwr		Strlwr
#	define strupr		Strupr

	extern "C++" ZAF_EXPORT ZafIChar *strdup(const ZafIChar *srcString);
	extern "C++" ZAF_EXPORT int stricmp(const ZafIChar *a, const ZafIChar *b);
	extern "C++" ZAF_EXPORT ZafIChar *strlwr(ZafIChar *string);
	extern "C++" ZAF_EXPORT ZafIChar *strupr(ZafIChar *string);
#endif

ZAF_EXPORT int streq(const ZafIChar *s1, const ZafIChar *s2);
#if defined(ZAF_UNICODE)
ZAF_EXPORT int streq(const ZafIChar *s1, const char *s2);
ZAF_EXPORT int streq(const char *s1, const char *s2);
#endif

ZAF_EXPORT void SwapInt16(ZafInt16 *datum);
ZAF_EXPORT void SwapUInt16(ZafUInt16 *datum);
ZAF_EXPORT void SwapInt32(ZafInt32 *datum);
ZAF_EXPORT void SwapUInt32(ZafUInt32 *datum);

ZAF_EXPORT int strneq(const ZafIChar *s1, const ZafIChar *s2, int n);
ZAF_EXPORT int strnicmp(const ZafIChar *a, const ZafIChar *b, int n);
ZAF_EXPORT void strrepc(ZafIChar *string, ZafIChar c, ZafIChar repc);
ZAF_EXPORT void strstrip(ZafIChar *string, ZafIChar c);
ZAF_EXPORT int WildStrcmp(const ZafIChar *str, const ZafIChar *pattern);

ZAF_EXPORT void itoa(ZafInt32 value, ZafIChar *string, int radix, int pad);
inline ZAF_EXPORT int ZafAbs(int value) { return ((value > 0) ? value : -value); }
inline ZAF_EXPORT int ZafMin(int arg1, int arg2) { return ((arg1 < arg2) ? arg1 : arg2); }
inline ZAF_EXPORT int ZafMax(int arg1, int arg2) { return ((arg1 > arg2) ? arg1 : arg2); }

#endif // Z_UTILS_HPP

