//	Zinc Application Framework - Z_UNISTD.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_UNISTD_HPP)
#define Z_UNISTD_HPP
#include <z_env.hpp>

#if defined(ZAF_ISO8859_1)
#	if defined(__BCPLUSPLUS__) || defined(__TCPLUSPLUS__)
#		include <dir.h>
#		include <io.h>
#		include <stdio.h>
#	elif defined(_MSC_VER)
#		include <direct.h>
#		include <io.h>
#	elif defined(__WATCOMC__) && !defined(__QNX__)
#		include <stdio.h>
#		include <direct.h>
#		include <io.h>
#	else
#		include <unistd.h>
#		if !defined(ZAF_MACINTOSH)
#			include <sys/stat.h>
#		endif
#	endif
#	if defined(__DVX__)
#		include <stdio.h>
#		include <direct.h>
#	elif defined(ZAF_MOTIF)
#		include <stdio.h>
#	endif

	ZAF_EXPORT int ChDir(const ZafIChar *path);
	ZAF_EXPORT ZafIChar *GetCwd(ZafIChar *path, unsigned int length);
	ZAF_EXPORT int Rename(const ZafIChar *oldPath, const ZafIChar *newPath);
	ZAF_EXPORT int Unlink(const ZafIChar *path);

#	define OSchdir	chdir
#	define OSgetcwd	getcwd
#	define OSrename	rename
#	define OSunlink	unlink
#	define OSremove	remove
#	define chdir	ChDir
#	define getcwd	GetCwd
#	define rename	Rename
#	define unlink	Unlink
#	define remove	Unlink
#elif defined(ZAF_UNICODE)
#	if defined(__BCPLUSPLUS__) || defined(__TCPLUSPLUS__)
#		include <dir.h>
#		include <io.h>
#	elif defined(_MSC_VER)
#		include <direct.h>
#		include <io.h>
#	elif defined(__WATCOMC__) && !defined(__QNX__)
#		include <stdio.h>
#		include <direct.h>
#		include <io.h>
#	else
#		include <unistd.h>
#	endif
#	if defined(__DVX__)
#		include <stdio.h>
#		include <direct.h>
#	endif

	extern "C++" ZAF_EXPORT int chdir(const ZafIChar *path);
	extern "C++" ZAF_EXPORT ZafIChar *getcwd(ZafIChar *path, unsigned int length);
	extern "C++" ZAF_EXPORT int rename(const ZafIChar *oldPath, const ZafIChar *newPath);
	extern "C++" ZAF_EXPORT int unlink(const ZafIChar *path);
	extern "C++" ZAF_EXPORT int remove(const ZafIChar *path);
#else
#	if defined(__BCPLUSPLUS__) || defined(__TCPLUSPLUS__)
#		include <dir.h>
#		include <io.h>
#	else
#		include <unistd.h>
#	endif
#	if defined(__DVX__)
#		include <stdio.h>
#		include <direct.h>
#	endif
#endif

#endif
