//	Zinc Application Framework - Z_TITLE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_TITLE_HPP)
#define Z_TITLE_HPP
#include <z_button.hpp>

// --------------------------------------------------------------------------
// ----- ZafTitle -----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafTitle : public ZafButton
{
public:
	// --- General members ---
	ZafTitle(const ZafIChar *text);
	ZafTitle(ZafStringData *textData);
	ZafTitle(const ZafTitle &copy);
	virtual ~ZafTitle(void);

	// --- Persistent members ---
	ZafTitle(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Button members ---
	virtual bool SetAllowDefault(bool allowDefault);
	virtual bool SetAllowToggling(bool allowToggling);
	virtual bool SetAutoRepeatSelection(bool autoRepeatSelection);
	virtual bool SetAutoSize(bool autoSize);
	virtual ZafError SetBitmapData(ZafBitmapData *bitmapData);
	virtual ZafButtonType SetButtonType(ZafButtonType buttonType);
	virtual bool SetDepressed(bool depressed);
	virtual int SetDepth(int depth);
	virtual ZafIChar SetHotKey(ZafIChar hotKeyChar, int index = -1);
	virtual ZafHzJustify SetHzJustify(ZafHzJustify hzJustify);
	virtual bool SetSelectOnDoubleClick(bool selectOnDoubleClick);
	virtual bool SetSelectOnDownClick(bool selectOnDownClick);
	virtual bool SetSendMessageWhenSelected(bool sendMessageWhenSelected);
	virtual ZafEventType SetValue(ZafEventType value);
	virtual ZafVtJustify SetVtJustify(ZafVtJustify vtJustify);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentDrawBorder(bool parentDrawBorder);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual const ZafIChar *SetQuickTip(const ZafIChar *quickTip);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSelected(bool selected);
	virtual bool SetSupportObject(bool supportObject);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafButton::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafButton::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSTitle;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetText(void);
	virtual void OSSize(void);
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

	// --- Persistent members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafTitle::Read); }

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

#endif // Z_TITLE_HPP

