//	Zinc Application Framework - Z_TIMER.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_TIMER_HPP)
#define Z_TIMER_HPP
#include <z_device.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafTimer -----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafTimer : public ZafDevice
{
public:
	// --- General members ---
	ZafTimer(ZafDeviceState state, unsigned long interval);
	ZafTimer(const ZafTimer &copy);
	virtual ~ZafTimer(void);

	// --- Attributes & data access ---
	// get
	unsigned long Interval(void) const;
	int NotifyCount(void) const;
	ZafEventType NotifyMessage(void) const;
	bool QueueEvents(void) const;
	// set
	virtual unsigned long SetInterval(unsigned long interval);
	ZafEventType SetNotifyMessage(ZafEventType notifyMessage);
	virtual bool SetQueueEvents(bool queueEvents);

	// --- Device members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual void Poll(void);

	// --- List members ---
	ZafWindowObject *Add(ZafWindowObject *object, ZafEventType newNotifyMessage, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject))
		{ return (notifyList.Add(object, newNotifyMessage, position)); }
	ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject))
		{ return (notifyList.Add(object, position)); }
	ZafWindowObject *Subtract(ZafWindowObject *object)
		{ return (notifyList.Subtract(object)); }

	ZafTimer &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafTimer &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafDevice::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafDevice::IsA(compareName)); }

protected:
	unsigned long interval;
	bool queueEvents;
	ZafEventType notifyMessage;

	// --- Notification ---
	class ZAF_EXPORT ZafNotifyList : public ZafList
	{
	public:
		class ZAF_EXPORT ZafNotifyElement : public ZafElement
		{
		public:
			ZafWindowObject *notifyObject;
			ZafEventType notifyMessage;

			ZafNotifyElement(ZafWindowObject *object, ZafEventType notifyMessage);
			virtual ~ZafNotifyElement(void);
			ZafNotifyElement *Next(void) const { return ((ZafNotifyElement *)next); }
			ZafNotifyElement *Previous(void) const { return ((ZafNotifyElement *)previous); }
		};

		virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
		virtual ZafWindowObject *Add(ZafWindowObject *object, ZafEventType notifyMessage, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
		ZafNotifyElement *Current(void) const { return ((ZafNotifyElement *)current); }
		ZafNotifyElement *First(void) const { return ((ZafNotifyElement *)first); }
		ZafNotifyElement *Last(void) const { return ((ZafNotifyElement *)last); }
		virtual ZafWindowObject *Subtract(ZafWindowObject *object);
	};
	ZafNotifyList notifyList;

private:
#if defined (ZAF_MSWINDOWS)
	UINT timerID;
#elif defined(ZAF_MOTIF)
	static void TimeOut(ZafTimer *timer, XtIntervalId *intervalID);
#elif defined(ZAF_MSDOS)
	unsigned long lastTime;
#elif defined(ZAF_MACINTOSH)
	typedef struct
	{
		TMTask tmTask;
		ZafTimer *timer;
		long tmRefCon;
	} TMInfo;

	TMInfo taskInfo;
	TimerUPP timerCallbackUPP;
#	if defined(__powerc)
	friend pascal void Task(TMTaskPtr tmTaskPtr);
#	else
	friend pascal void Task(void);
#	endif
#endif
};

// --- inline functions ---
inline unsigned long ZafTimer::Interval(void) const { return interval; }
inline bool ZafTimer::QueueEvents(void) const { return queueEvents; }
inline int ZafTimer::NotifyCount(void) const { return (notifyList.Count()); }
inline ZafEventType ZafTimer::NotifyMessage(void) const { return notifyMessage; }

#endif // Z_TIMER_HPP

