//	Zinc Application Framework - Z_SYSEVT.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_SYSEVT_HPP)
#define Z_SYSEVT_HPP
#include <z_event.hpp>

// --------------------------------------------------------------------------
// ----- ZafSystemEvent -----------------------------------------------------
// --------------------------------------------------------------------------

const ZafSystemEvent S_ERROR				= -1;	// No union information
const ZafSystemEvent S_UNKNOWN				= -2;
const ZafSystemEvent S_NO_OBJECT			= -3;
const ZafSystemEvent S_MINIMIZE				= -4;
const ZafSystemEvent S_MAXIMIZE				= -5;
// unused									= -6;
const ZafSystemEvent S_CONTINUE				= -7;
// unused									= -8;
const ZafSystemEvent S_INITIALIZE			= -9;
const ZafSystemEvent S_CREATE				= -10;
const ZafSystemEvent S_CLOSE				= -11;
const ZafSystemEvent S_NON_CURRENT			= -13;
// unused									= -14;
// unused									= -15;
const ZafSystemEvent S_REDISPLAY_DATA		= -16;
const ZafSystemEvent S_REDISPLAY			= -17;
const ZafSystemEvent S_CLOSE_TEMPORARY		= -18;
// unused									= -19;
const ZafSystemEvent S_DEINITIALIZE			= -20;
// unused									= -21;
// unused									= -22;
// unused									= -23;
// unused									= -24;
const ZafSystemEvent S_RESTORE				= -25;
const ZafSystemEvent S_REGISTER_OBJECT		= -26;
const ZafSystemEvent S_DESTROY				= -27;
const ZafSystemEvent S_REDISPLAY_REGION		= -28;	// ZafRegionStruct information
const ZafSystemEvent S_CUT					= -29;
const ZafSystemEvent S_PASTE				= -30;
const ZafSystemEvent S_COPY					= -31;
const ZafSystemEvent S_EXIT					= -32;
const ZafSystemEvent S_NEXT_WINDOW			= -33;
const ZafSystemEvent S_HELP					= -34;
const ZafSystemEvent S_MOVE_MODE			= -35;
const ZafSystemEvent S_SIZE_MODE			= -36;

const ZafSystemEvent S_HOT_KEY         		= -120; // ZafKeyStruct information

const ZafSystemEvent S_SIZE					= -200;
const ZafSystemEvent S_COMPUTE_SIZE			= -201;
// unused									= -202;
// unused									= -203;
const ZafSystemEvent S_CURRENT				= -204;	// ZafRegionStruct information

// unused									= -210;
// unused									= -211;

const ZafSystemEvent S_REDISPLAY_DEFAULT	= -220; // Default buttons

const ZafSystemEvent S_VSCROLL				= -300;	// Scroll Events
const ZafSystemEvent S_HSCROLL				= -301;
const ZafSystemEvent S_VSCROLL_SET			= -302;
const ZafSystemEvent S_HSCROLL_SET			= -303;
const ZafSystemEvent S_VSCROLL_CHECK		= -304;
const ZafSystemEvent S_HSCROLL_CHECK 		= -305;
const ZafSystemEvent S_VSCROLL_COMPUTE		= -306;
const ZafSystemEvent S_HSCROLL_COMPUTE		= -307;
// unused									= -308;

const ZafSystemEvent S_DECREMENT			= -350; // ZafSpinControl
const ZafSystemEvent S_INCREMENT			= -351;

const ZafSystemEvent S_ADD_OBJECT			= -400;	// *windowObject, *device
const ZafSystemEvent S_SUBTRACT_OBJECT		= -401;	// *windowObject, *device
// unused									= -402;
const ZafSystemEvent S_DRAG_MOVE			= -403;	// ZafPositionStruct information
const ZafSystemEvent S_DRAG_COPY			= -404;	// ZafPositionStruct information
const ZafSystemEvent S_DROP_MOVE			= -405;	// ZafPositionStruct information
const ZafSystemEvent S_DROP_COPY			= -406;	// ZafPositionStruct information
const ZafSystemEvent S_DRAG_LINK			= -407;	// ZafPositionStruct information
const ZafSystemEvent S_DROP_LINK			= -408;	// ZafPositionStruct information
const ZafSystemEvent S_BEGIN_DRAG			= -409;	// ZafPositionStruct information
const ZafSystemEvent S_END_DRAG				= -410;	// ZafPositionStruct information

const ZafSystemEvent S_DRAG_DEFAULT			= -411;	// ZafPositionStruct information
const ZafSystemEvent S_DROP_DEFAULT			= -412;	// ZafPositionStruct information

const ZafSystemEvent S_COPY_DATA			= -420;
const ZafSystemEvent S_SET_DATA				= -421;

// unused									= -500;
const ZafSystemEvent S_MDI_CLOSE			= -501;
const ZafSystemEvent S_MDI_MAXIMIZE			= -502;
const ZafSystemEvent S_MDI_MINIMIZE			= -503;
const ZafSystemEvent S_MDI_RESTORE			= -504;
const ZafSystemEvent S_MDI_NEXT_WINDOW		= -505;
const ZafSystemEvent S_MDI_MOVE_MODE		= -506;
const ZafSystemEvent S_MDI_SIZE_MODE		= -507;
const ZafSystemEvent S_MDI_CASCADE_WINDOWS	= -508;
const ZafSystemEvent S_MDI_TILE_WINDOWS		= -509;

#endif // Z_SYSEVT_HPP

