//	Zinc Application Framework - Z_SYS.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_SYS_HPP)
#define Z_SYS_HPP
#include <z_button.hpp>
#include <z_popup.hpp>

// --------------------------------------------------------------------------
// ----- ZafSystemButton ----------------------------------------------------
// --------------------------------------------------------------------------

enum ZafSystemButtonType
{
	ZAF_NATIVE_SYSTEM_BUTTON	= 0,
	ZAF_EMPTY_SYSTEM_BUTTON		= 1
};

class ZAF_EXPORT ZafSystemButton : public ZafButton
{
public:
	// --- General members ---
	ZafPopUpMenu menu;

	ZafSystemButton(ZafSystemButtonType systemButtonType = ZAF_NATIVE_SYSTEM_BUTTON);
	ZafSystemButton(const ZafSystemButton &copy);
	virtual ~ZafSystemButton(void);

	// --- Persistent members ---
	ZafSystemButton(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafSystemButtonType SystemButtonType(void) const;
	// set
	virtual ZafSystemButtonType SetSystemButtonType(ZafSystemButtonType systemButtonType);

	// --- Button members ---
	virtual bool SetAllowDefault(bool allowDefault);
	virtual bool SetAllowToggling(bool allowToggling);
	virtual bool SetAutoRepeatSelection(bool autoRepeatSelection);
	virtual bool SetAutoSize(bool autoSize);
	virtual ZafButtonType SetButtonType(ZafButtonType buttonType);
	virtual int SetDepth(int depth);
	virtual ZafIChar SetHotKey(ZafIChar hotKeyChar, int index = -1);
	virtual ZafHzJustify SetHzJustify(ZafHzJustify hzJustify);
	virtual bool SetSelectOnDoubleClick(bool selectOnDoubleClick);
	virtual bool SetSelectOnDownClick(bool selectOnDownClick);
	virtual bool SetSendMessageWhenSelected(bool sendMessageWhenSelected);
	virtual ZafEventType SetValue(ZafEventType value);
	virtual ZafVtJustify SetVtJustify(ZafVtJustify vtJustify);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentDrawBorder(bool parentDrawBorder);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual const ZafIChar *SetQuickTip(const ZafIChar *quickTip);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSelected(bool selected);
	virtual bool SetSupportObject(bool supportObject);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	int Count(void) { return (menu.Count()); };
	ZafWindowObject *Current(void) const { return ((ZafWindowObject *)menu.Current()); }
	virtual void Destroy(void) { menu.Destroy(); }
	ZafWindowObject *First(void) const { return ((ZafWindowObject *)menu.First()); }
	ZafWindowObject *Get(int index) { return ((ZafWindowObject *)menu.ZafList::Get(index)); }
	int Index(ZafWindowObject const *element) { return (menu.Index(element)); }
	ZafWindowObject *Last(void) const { return((ZafWindowObject *)menu.Last()); }
	virtual void Sort(void) { menu.Sort(); }
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);

	ZafSystemButton &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafSystemButton &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafButton::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafButton::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSSystemButton;

	// --- General members ---
	ZafSystemButtonType systemButtonType;

	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual void OSRegisterObject(void);
	virtual void OSSize(void);
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafSystemButton::Read); }
	void WriteData(ZafObjectPersistence &persist);

	// --- Image, language & locale support ---
	static char sysName[];
	static ZafBitmapData *sysBitmap;
	static ZafLanguageData *language;
	static void ImageAllocate(void);
	static void ImageFree(bool globalRequest = false);
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

// --- inline functions ---
inline ZafSystemButtonType ZafSystemButton::SystemButtonType(void) const { return systemButtonType; }

#endif // Z_SYS_HPP

