//	Zinc Application Framework - Z_STR1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_STR1_HPP)
#define Z_STR1_HPP
#include <z_str.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafString ----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafString : public ZafWindowObject
{
public:
	// --- General members ---
	ZafString(int left, int top, int width,
		ZafStringData *stringData = ZAF_NULLP(ZafStringData));
	ZafString(int left, int top, int width,
		const ZafIChar *text, int maxLength);
	ZafString(const ZafString &copy);
	virtual ~ZafString(void);
	ZafEventType DefaultValidateFunction(const ZafEventStruct &event, ZafEventType ccode);

	// --- Persistent members ---
	ZafString(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	bool AutoClear(void) const;
	int CursorOffset(void) const;
	ZafHzJustify HzJustify(void) const;
	ZafStringData *InputFormatData(void) const;
	const ZafIChar *InputFormatText(void) const;
	bool Invalid(void) const;
	bool LowerCase(void) const;
	ZafStringData *OutputFormatData(void) const;
	const ZafIChar *OutputFormatText(void) const;
	bool Password(void) const;
	ZafStringData *RangeData(void) const;
	const ZafIChar *RangeText(void) const;
	ZafStringData *StringData(void) const;
	virtual const ZafIChar *Text(void);
	bool Unanswered(void) const;
	bool UpperCase(void) const;
	bool VariableName(void) const;
	bool ViewOnly(void) const;
	// set
	virtual bool SetAutoClear(bool autoClear);
	virtual ZafError SetCursorOffset(int position);
	virtual ZafHzJustify SetHzJustify(ZafHzJustify hzJustify);
	ZafError SetInputFormat(const ZafIChar *format);
	virtual ZafError SetInputFormatData(ZafStringData *format);
	virtual bool SetInvalid(bool invalid);
	virtual bool SetLowerCase(bool lowerCase);
	ZafError SetOutputFormat(const ZafIChar *format);
	virtual ZafError SetOutputFormatData(ZafStringData *format);
	virtual bool SetPassword(bool password);
	ZafError SetRange(const ZafIChar *range);
	virtual ZafError SetRangeData(ZafStringData *range);
	virtual bool SetSelected(bool selected);
	virtual ZafError SetStringData(ZafStringData *string);
	virtual ZafError SetText(const ZafIChar *text);
	virtual bool SetUnanswered(bool unanswered);
	virtual bool SetUpperCase(bool upperCase);
	virtual bool SetViewOnly(bool viewOnly);
	virtual bool SetVariableName(bool variableName);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSString;
	friend class ZAF_EXPORT ZafSpinControl;

	// --- General members ---
	bool autoClear;
	bool invalid;
	bool unanswered;
	bool lowerCase;
	bool password;
	bool upperCase;
	bool variableName;
	bool viewOnly;
	ZafHzJustify hzJustify;
	ZafStringData *inputFormatData;
	ZafStringData *outputFormatData;
	ZafStringData *rangeData;

	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Data access ---
	ZafStringData *stringData;
	virtual ZafError Decrement(ZafData *data);
	virtual ZafError Increment(ZafData *data);
	static ZafError Update(ZafString *string, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return string->OSSetText();
		  else if (type == ZAF_UPDATE_DATA) return string->OSGetText();
		  else return (ZAF_ERROR_INVALID); }
	const ZafIChar *ParseRange(const ZafIChar *buffer, ZafIChar *minValue, ZafIChar *maxValue);
	virtual ZafError Validate(bool processError = true);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual ZafError OSGetText(void);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetText(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafString::Read); }
	void WriteData(ZafObjectPersistence &persist);

#	if defined(ZAF_MSDOS) || defined(ZAF_CURSES)
	int cursor, beginMark, endMark, length, firstDisplayedChar;
#	elif defined(ZAF_MACINTOSH)
	long selectPosition;
#	endif

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafEventMap ZAF_FARDATA defaultEventMap[];
};

// --- inline functions ---
inline ZafStringData *ZafString::InputFormatData(void) const { return inputFormatData; }
inline ZafStringData *ZafString::OutputFormatData(void) const { return outputFormatData; }
inline ZafStringData *ZafString::RangeData(void) const { return rangeData; }
inline ZafStringData *ZafString::StringData(void) const { return stringData; }

inline bool ZafString::AutoClear(void) const { return autoClear; }
inline ZafHzJustify ZafString::HzJustify(void) const { return hzJustify; }
inline const ZafIChar *ZafString::InputFormatText(void) const { return (inputFormatData ? inputFormatData->Text() : ZAF_NULLP(ZafIChar)); }
inline bool ZafString::Invalid(void) const { return invalid; }
inline bool ZafString::LowerCase(void) const { return lowerCase; }
inline const ZafIChar *ZafString::OutputFormatText(void) const { return (outputFormatData ? outputFormatData->Text() : ZAF_NULLP(ZafIChar)); }
inline bool ZafString::Password(void) const { return password; }
inline const ZafIChar *ZafString::RangeText(void) const { return (rangeData ? rangeData->Text() : ZAF_NULLP(ZafIChar)); }
inline bool ZafString::Unanswered(void) const { return unanswered; }
inline bool ZafString::UpperCase(void) const { return upperCase; }
inline bool ZafString::VariableName(void) const { return variableName; }
inline bool ZafString::ViewOnly(void) const { return viewOnly; }

#endif // Z_STR1_HPP

