//	Zinc Application Framework - Z_STDLIB.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_STDLIB_HPP)
#define Z_STDLIB_HPP
#include <z_env.hpp>

#if defined(ZAF_ISO8859_1)
#	if defined(__DECCXX) || (defined(__GNUC__) && defined(__alpha__)) || defined(_SUNOS4)
#	include <z_unistd.hpp>
#	endif
#	include <stdlib.h>

	ZAF_EXPORT ZafIChar *GetEnv(const ZafIChar *envname);
#	define OSgetenv getenv
#	define getenv GetEnv
#	if defined(_SUNOS4)
	extern "C++" ZAF_EXPORT unsigned long strtoul(const ZafIChar *s, ZafIChar **endptr, int radix);
#	endif
#elif defined(ZAF_UNICODE)
#	include <stdlib.h>

	extern "C++" ZAF_EXPORT ZafIChar *getenv(const ZafIChar *envname);

	extern "C++" ZAF_EXPORT double atof(const ZafIChar *nptr);
	extern "C++" ZAF_EXPORT int atoi(const ZafIChar *nptr);
	extern "C++" ZAF_EXPORT long atol(const ZafIChar *nptr);
	extern "C++" ZAF_EXPORT double strtod(const ZafIChar *s, ZafIChar **endptr);
	extern "C++" ZAF_EXPORT long strtol(const ZafIChar *s, ZafIChar **endptr, int radix);
	extern "C++" ZAF_EXPORT unsigned long strtoul(const ZafIChar *s, ZafIChar **endptr, int radix);
#else
#	include <stdlib.h>
#endif

#endif
