//	Zinc Application Framework - Z_STDIO.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_STDIO_HPP)
#define Z_STDIO_HPP
#include <z_env.hpp>

#if defined(ZAF_ISO8859_1)
#	if defined(_SUNOS4)
#	include <z_stdlib.hpp>
#	endif
#	include <stdio.h>

	ZAF_EXPORT FILE *FOpen(const ZafIChar *path, const ZafIChar *mode);
	ZAF_EXPORT int SPrintf(ZafIChar *buffer, const ZafIChar *format, ...);
	ZAF_EXPORT int SScanf(const ZafIChar *buffer, const ZafIChar *format, ...);
	ZAF_EXPORT ZafIChar *TmpNam(ZafIChar *path);
#	define OSfopen		fopen
#	define OSsprintf	sprintf
#	define OSsscanf		sscanf
#	define OStmpnam		tmpnam
#	define fopen		FOpen
#	define sprintf		SPrintf
#	define sscanf		SScanf
#	define tmpnam		TmpNam
#elif defined(ZAF_UNICODE)
#	include <stdio.h>

	extern "C++" ZAF_EXPORT FILE *fopen(const ZafIChar *path, const ZafIChar *mode);
	extern "C++" ZAF_EXPORT int sprintf(ZafIChar *buffer, const ZafIChar *format, ...);
	extern "C++" ZAF_EXPORT int sscanf(const ZafIChar *buffer, const ZafIChar *format, ...);
	extern "C++" ZAF_EXPORT ZafIChar *tmpnam(ZafIChar *path);
#else
#	include <stdio.h>
#endif

#endif
