//	Zinc Application Framework - Z_STATUS.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_STATUS_HPP)
#define Z_STATUS_HPP
#include <z_bitmap.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafStatusBar -------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafStatusBar : public ZafWindow
{
public:
	// --- General members ---
	ZafStatusBar(int left, int top, int right, int bottom);
	ZafStatusBar(const ZafStatusBar &copy);
	virtual ~ZafStatusBar(void);

	// --- Persistent members ---
	ZafStatusBar(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual void ConvertRegion(ZafRegionStruct &region, ZafCoordinateType newType);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSupportObject(bool supportObject);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);

	ZafStatusBar &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafStatusBar &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

#if defined(ZAF_MSWINDOWS)
	// --- Image Support ---
	static ZafBitmapData *sizeGripBitmap;
	static void ImageAllocate(void);
	static void ImageFree(bool globalRequest = false);
#endif

protected:
	friend class ZAF_EXPORT OSStatusBar;

	// --- General members ---
	virtual ZafPositionStruct ConvertToOSPosition(const ZafWindowObject *object,
		const ZafPositionStruct *zafPosition = ZAF_NULLP(ZafPositionStruct)) const;
	virtual ZafPositionStruct ConvertToZafPosition(const ZafWindowObject *object,
		const ZafPositionStruct *osPosition = ZAF_NULLP(ZafPositionStruct)) const;
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafRegionStruct MaxRegion(ZafWindowObject *object,
		ZafVtJustify vWeight = ZAF_VT_TOP, ZafHzJustify hWeight = ZAF_HZ_LEFT);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafStatusBar::Read); }

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

#endif // Z_STATUS_HPP

