//	Zinc Application Framework - Z_SPIN.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_SPIN_HPP)
#define Z_SPIN_HPP
#include <z_fdata.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafSpinControl -----------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafSpinControl : public ZafWindow
{
public:
	// --- General members ---
	ZafSpinControl(int left, int top, int width, ZafData *delta);
	ZafSpinControl(const ZafSpinControl &copy);
	virtual ~ZafSpinControl(void);

	// --- Persistent members ---
	ZafSpinControl(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	const ZafData *Delta(void);
	// set
	virtual ZafError SetDelta(ZafData *data);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual bool Changed(void) const;
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);
	virtual const ZafIChar *Text(void);
	bool ViewOnly(void) const;
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetChanged(bool changed);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual const ZafIChar *SetQuickTip(const ZafIChar *quickTip);
	virtual bool SetSystemObject(bool systemObject);
	virtual ZafError SetText(const ZafIChar *text);
	virtual bool SetViewOnly(bool viewOnly);
	virtual bool SetVisible(bool visible);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);

	ZafSpinControl &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafSpinControl &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

protected:
	friend class ZAF_EXPORT OSSpinControl;

	// --- General members ---
	bool viewOnly;
	ZafData *delta;

	static ZafEventType ChildCallback(ZafWindowObject *object, ZafEventStruct &event, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafSpinControl::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafEventMap ZAF_FARDATA defaultEventMap[];

#	if defined(ZAF_MSWINDOWS)
#		if defined (ZAF_WIN32)
	HWND hwndUpDown;
#		else
	unsigned int spinState;
#		endif
#	elif defined(ZAF_MOTIF)
	ZafRegionStruct upArrow, downArrow;
	void DrawArrows(bool upDepressed, bool downDepressed);
#	endif
};

// --- inline functions ---
inline bool ZafSpinControl::Changed(void) const { return (First() ? First()->Changed() : changed); }
inline bool ZafSpinControl::ViewOnly(void) const { return viewOnly; }
inline const ZafData *ZafSpinControl::Delta(void) { return (delta); }

#endif // Z_SPIN_HPP

