//	Zinc Application Framework - Z_SCRLL.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_SCROLL_HPP)
#define Z_SCROLL_HPP
#include <z_env.hpp>

// --------------------------------------------------------------------------
// ----- ZafScrollStruct ----------------------------------------------------
// --------------------------------------------------------------------------
// --- event.type is S_VSCROLL_* or S_HSCROLL_*
// --- event.scroll.current is current scroll position
// --- event.scroll.minimun is minimum scroll position
// --- event.scroll.maximum is maximum scroll position
// --- event.scroll.showing is fraction of scroll showing on screen.
// --- event.scroll.delta is scrolling increment

struct ZAF_EXPORT ZafScrollStruct
{
	long current;
	long minimum;
	long maximum;
	long showing;
	long delta;

	// --- Operators ---
	bool operator==(const ZafScrollStruct &scroll) const;
	bool operator!=(const ZafScrollStruct &scroll) const;
};

// --- inline functions ---
inline bool ZafScrollStruct::operator==(const ZafScrollStruct &scroll) const
	{ return (scroll.minimum == minimum && scroll.current == current &&
			  scroll.maximum == maximum && scroll.showing == showing &&
			  scroll.delta == delta); }
inline bool ZafScrollStruct::operator!=(const ZafScrollStruct &scroll) const
	{ return (scroll.minimum != minimum || scroll.current != current ||
			  scroll.maximum != maximum || scroll.showing != showing ||
			  scroll.delta != delta); }

#endif // Z_SCROLL_HPP

