//	Zinc Application Framework - Z_REAL1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_REAL1_HPP)
#define Z_REAL1_HPP
#include <z_real.hpp>
#include <z_str1.hpp>

// --------------------------------------------------------------------------
// ----- ZafReal ------------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafReal : public ZafString
{
public:
	// --- General members ---
	ZafReal(int left, int top, int width,
		ZafRealData *realData = ZAF_NULLP(ZafRealData));
	ZafReal(int left, int top, int width,
		double value);
	ZafReal(const ZafReal &copy);
	virtual ~ZafReal(void);

	// --- Persistent members ---
	ZafReal(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafRealData *RealData(void) const;
	// set
	virtual ZafError SetRealData(ZafRealData *number);

	// --- String members ---
	virtual bool SetLowerCase(bool lowerCase);
	virtual bool SetPassword(bool password);
	virtual ZafError SetStringData(ZafStringData *string);
	virtual bool SetUpperCase(bool upperCase);
	virtual bool SetVariableName(bool variableName);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafError SetText(const ZafIChar *text);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafString::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafString::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSReal;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);

	// --- Data access ---
	ZafRealData *realData;
	virtual ZafError Decrement(ZafData *data);
	virtual ZafError Increment(ZafData *data);
	static ZafError Update(ZafReal *real, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return real->OSSetReal();
		  else if (type == ZAF_UPDATE_DATA) return real->OSGetReal();
		  else return (ZAF_ERROR_INVALID); }
	virtual ZafError Validate(bool processError = true);

	// --- Special OS members ---
	ZafError OSGetReal(void);
	ZafError OSSetReal(void);

	// --- Language & locale support ---
	static ZafLanguageData *errorStrings;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafReal::Read); }
	void WriteData(ZafObjectPersistence &persist);
};

// --- inline functions ---
inline ZafRealData *ZafReal::RealData(void) const { return realData; }
inline ZafError ZafReal::SetText(const ZafIChar *text) { return (realData->SetReal(text, inputFormatData ? inputFormatData->Text() : ZAF_NULLP(ZafIChar))); }

#endif // Z_REAL1_HPP

