//	Zinc Application Framework - Z_REAL.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_REAL_HPP)
#define Z_REAL_HPP
#include <z_fdata.hpp>
#include <z_stdarg.hpp>

// --------------------------------------------------------------------------
// ----- ZafRealData --------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafRealData : public ZafFormatData
{
public:
	// -- General members ---
	ZafRealData(void);
	ZafRealData(double value);
	ZafRealData(const ZafIChar *string, const ZafIChar *format = ZAF_NULLP(ZafIChar));
	ZafRealData(const ZafRealData &copy);
	virtual ~ZafRealData(void);

	// --- Persistence ---
	ZafRealData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	virtual int FormattedText(ZafIChar *buffer, int maxLength, const ZafIChar *format = 0) const;
	double Value(void) const;
	// set
	virtual void Clear(void);
	virtual ZafError SetReal(double value);
	virtual ZafError SetReal(const ZafIChar *buffer, const ZafIChar *format);
	virtual ZafError SetReal(const ZafRealData &real);

	// --- Operators ---
	operator double() { return value; }

	ZafRealData operator++(void);
	ZafRealData operator++(int);
	ZafRealData operator--(void);
	ZafRealData operator--(int);

	ZafRealData &operator=(double value);
	ZafRealData &operator+=(double value);
	ZafRealData &operator-=(double value);
	ZafRealData &operator*=(double value);
	ZafRealData &operator/=(double value);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafFormatData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafFormatData::IsA(compareName)); }

protected:
	// --- Persistence ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafRealData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);

private:
	friend class ZAF_EXPORT ZafBignumData;

	double value;

	static void Bind(void);
	static void Format(va_list *argList, ZafIChar **ptrBuffer, ZafIChar fmtch, int flags, int width, int prec);
	static int Parse(va_list *argList, ZafIChar **ptrBuffer, ZafIChar fmtch, int flags, int width, const ZafIChar **fmt);
};

// --- inline functions ---
inline double ZafRealData::Value(void) const { return value; }

#endif // Z_REAL_HPP

