//	Zinc Application Framework - Z_POPUP.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_POPUP_HPP)
#define Z_POPUP_HPP
#include <z_button.hpp>

// --------------------------------------------------------------------------
// ----- ZafPopUpMenu -------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafPopUpMenu : public ZafWindow
{
public:
	// --- General members ---
	ZafPopUpMenu(int left, int top);
	ZafPopUpMenu(const ZafPopUpMenu &copy);
	virtual ~ZafPopUpMenu(void);

	// --- Persistent members ---
	ZafPopUpMenu(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentPalette(bool parentPalette);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);

	// --- List members ---
	ZafPopUpMenu &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafPopUpMenu &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

protected:
	friend class ZAF_EXPORT OSPopUpMenu;
	friend class ZAF_EXPORT ZafPopUpItem;
	friend class ZAF_EXPORT ZafPullDownItem;
	friend class ZAF_EXPORT ZafSystemButton;

	// --- General members ---
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual void GetClip(ZafWindowObject *object, ZafRegionStruct &clip, ZafRegionStruct &virtualRegion);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSRegisterObject(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafPopUpMenu::Read); }
	void WriteData(ZafObjectPersistence &persist);
};

// --------------------------------------------------------------------------
// ----- ZafPopUpItem -------------------------------------------------------
// --------------------------------------------------------------------------

enum ZafPopUpItemType
{
	ZAF_NORMAL_ITEM = 0,
	ZAF_ABOUT_OPTION,
	ZAF_CLOSE_OPTION,
	ZAF_MAXIMIZE_OPTION,
	ZAF_MINIMIZE_OPTION,
	ZAF_MOVE_OPTION,
	ZAF_RESTORE_OPTION,
	ZAF_SEPARATOR,
	ZAF_SIZE_OPTION,
	ZAF_SWITCH_OPTION,
	ZAF_EXIT_OPTION,
	ZAF_COPY_OPTION,
	ZAF_CUT_OPTION,
	ZAF_PASTE_OPTION
};

class ZAF_EXPORT ZafPopUpItem : public ZafButton
{
public:
	// --- General class members ---
	ZafPopUpMenu menu;

	ZafPopUpItem(const ZafIChar *text,
		ZafPopUpItemType itemType = ZAF_NORMAL_ITEM);
	ZafPopUpItem(ZafStringData *stringData,
		ZafPopUpItemType itemType = ZAF_NORMAL_ITEM);
	ZafPopUpItem(const ZafPopUpItem &copy);
	virtual ~ZafPopUpItem(void);

	// --- Persistent members ---
	ZafPopUpItem(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafPopUpItemType ItemType(void) const;
	// set
	virtual ZafPopUpItemType SetItemType(ZafPopUpItemType itemType);
	virtual bool SetSelected(bool selected);

	// --- Button members ---
	virtual bool SetAllowDefault(bool allowDefault);
	virtual bool SetAutoRepeatSelection(bool autoRepeatSelection);
	virtual bool SetAutoSize(bool autoSize);
	virtual ZafError SetBitmapData(ZafBitmapData *bitmapData);
	virtual ZafButtonType SetButtonType(ZafButtonType buttonType);
	virtual bool SetDepressed(bool depressed);
	virtual int SetDepth(int depth);
	virtual ZafHzJustify SetHzJustify(ZafHzJustify hzJustify);
	virtual bool SetSelectOnDoubleClick(bool selectOnDoubleClick);
	virtual bool SetSelectOnDownClick(bool selectOnDownClick);
	virtual ZafVtJustify SetVtJustify(ZafVtJustify vtJustify);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafWindowObject *FocusObject(void) const;
	virtual ZafWindowObject *GetObject(ZafNumberID numberID);
	virtual ZafWindowObject *GetObject(const ZafIChar *stringID);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetParentDrawBorder(bool parentDrawBorder);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSupportObject(bool supportObject);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject)) { return (menu.Add(object, position)); }
	int Count(void) const { return (menu.Count()); };
	ZafWindowObject *Current(void) const { return ((ZafWindowObject *)menu.Current()); }
	virtual void Destroy(void) { menu.Destroy(); }
	ZafWindowObject *First(void) const { return ((ZafWindowObject *)menu.First()); }
	ZafWindowObject *Get(int index) { return ((ZafWindowObject *)menu.ZafList::Get(index)); }
	int Index(ZafWindowObject const *element) { return (menu.Index(element)); }
	ZafWindowObject *Last(void) const { return((ZafWindowObject *)menu.Last()); }
	virtual void Sort(void) { menu.Sort(); }
	virtual ZafWindowObject *Subtract(ZafWindowObject *object) { return (menu.Subtract(object)); }

	ZafPopUpItem &operator+(ZafWindowObject *object) { menu.Add(object); return(*this); }
	ZafPopUpItem &operator-(ZafWindowObject *object) { menu.Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafButton::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafButton::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSPopUpItem;

	// --- General members ---
	ZafPopUpItemType itemType;

	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetText(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	virtual void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafPopUpItem::Read); }
	virtual void WriteData(ZafObjectPersistence &persist);

	// --- Image & Language support ---
	static char ZAF_FARDATA popupArrowName[];
	static char ZAF_FARDATA popupArrowCurrentName[];
	static char ZAF_FARDATA popupCheckName[];
	static char ZAF_FARDATA popupCheckCurrentName[];
	static ZafBitmapData *popupArrowBitmap;
	static ZafBitmapData *popupArrowCurrentBitmap;
	static ZafBitmapData *popupCheckBitmap;
	static ZafBitmapData *popupCheckCurrentBitmap;
	static ZafLanguageData *language;
	static void ImageAllocate(void);
	static void ImageFree(bool globalRequest = false);
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

// --- inline functions ---
inline ZafPopUpItemType ZafPopUpItem::ItemType(void) const { return (itemType); }

#endif // Z_POPUP_HPP

