//	Zinc Application Framework - Z_PLLDN.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_PLLDN_HPP)
#define Z_PLLDN_HPP
#include <z_button.hpp>
#include <z_popup.hpp>

// --------------------------------------------------------------------------
// ----- ZafPullDownMenu ----------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafPullDownMenu : public ZafWindow
{
public:
	// --- General members ---
	ZafPullDownMenu(void);
	ZafPullDownMenu(const ZafPullDownMenu &copy);
	virtual ~ZafPullDownMenu(void);

	// --- Persistent members ---
	ZafPullDownMenu(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentPalette(bool parentPalette);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSupportObject(bool supportObject);

	// --- List members ---
	ZafPullDownMenu &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafPullDownMenu &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

protected:
	friend class ZAF_EXPORT OSPullDownMenu;
	friend class ZAF_EXPORT ZafPullDownItem;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafRegionStruct MaxRegion(ZafWindowObject *object,
		ZafVtJustify vWeight = ZAF_VT_TOP, ZafHzJustify hWeight = ZAF_HZ_LEFT);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSRegisterObject(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafPullDownMenu::Read); }
};

// --------------------------------------------------------------------------
// ----- ZafPullDownItem ----------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafPullDownItem : public ZafButton
{
public:
	// --- General members ---
	ZafPopUpMenu menu;

	ZafPullDownItem(const ZafIChar *text);
	ZafPullDownItem(ZafStringData *stringData);
	ZafPullDownItem(const ZafPullDownItem &copy);
	virtual ~ZafPullDownItem(void);
	virtual ZafWindowObject *GetObject(ZafNumberID numberID);
	virtual ZafWindowObject *GetObject(const ZafIChar *stringID);

	// --- Persistent members ---
	ZafPullDownItem(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Button members ---
	virtual bool SetAllowDefault(bool allowDefault);
	virtual bool SetAllowToggling(bool allowToggling);
	virtual bool SetAutoRepeatSelection(bool autoRepeatSelection);
	virtual bool SetAutoSize(bool autoSize);
	virtual ZafError SetBitmapData(ZafBitmapData *bitmapData);
	virtual ZafButtonType SetButtonType(ZafButtonType buttonType);
	virtual bool SetDepressed(bool depressed);
	virtual int SetDepth(int depth);
	virtual ZafHzJustify SetHzJustify(ZafHzJustify hzJustify);
	virtual bool SetSelectOnDoubleClick(bool selectOnDoubleClick);
	virtual bool SetSelectOnDownClick(bool selectOnDownClick);
	virtual bool SetSendMessageWhenSelected(bool sendMessageWhenSelected);
	virtual ZafEventType SetValue(ZafEventType value);
	virtual ZafVtJustify SetVtJustify(ZafVtJustify vtJustify);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafWindowObject *FocusObject(void) const;
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetParentDrawBorder(bool parentDrawBorder);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSelected(bool selected);
	virtual bool SetSupportObject(bool supportObject);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject)) { return (menu.Add(object, position)); }
	int Count(void) const { return (menu.Count()); };
	ZafWindowObject *Current(void) const { return ((ZafWindowObject *)menu.Current()); }
	virtual void Destroy(void) { menu.Destroy(); }
	ZafWindowObject *First(void) const { return ((ZafWindowObject *)menu.First()); }
	ZafWindowObject *Get(int index) { return ((ZafWindowObject *)menu.ZafList::Get(index)); }
	int Index(ZafWindowObject const *element) { return (menu.Index(element)); }
	ZafWindowObject *Last(void) const { return((ZafWindowObject *)menu.Last()); }
	virtual void Sort(void) { menu.Sort(); }
	virtual ZafWindowObject *Subtract(ZafWindowObject *object) { return (menu.Subtract(object)); }

	ZafPullDownItem &operator+(ZafWindowObject *object) { menu.Add(object); return(*this); }
	ZafPullDownItem &operator-(ZafWindowObject *object) { menu.Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafButton::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafButton::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSPullDownItem;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetText(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafPullDownItem::Read); }

	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

#endif // Z_PLLDN_HPP

