//	Zinc Application Framework - Z_PAL1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_PAL1_HPP)
#define Z_PAL1_HPP
#include <z_pal.hpp>
#include <z_data.hpp>

// --------------------------------------------------------------------------
// ----- ZafPaletteData -----------------------------------------------------
// --------------------------------------------------------------------------

struct ZAF_EXPORT ZafPaletteMap
{
	ZafPaletteType type;
	ZafPaletteState state;
	ZafPaletteStruct palette;
};

class ZAF_EXPORT ZafPaletteData : public ZafData
{
public:
	// --- General members ---
	ZafPaletteData(bool staticData = false);
	ZafPaletteData(ZafPaletteMap *mapTable, bool staticData = false);
	ZafPaletteData(const ZafPaletteData &copy);
	virtual ~ZafPaletteData(void);

	// --- Persistent members ---
	ZafPaletteData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	operator const ZafPaletteMap *() { return (mapTable); }
	// get
	ZafPaletteStruct GetPalette(ZafPaletteType type, ZafPaletteState state);
	bool StaticData(void) const;
	const ZafPaletteMap *MapTable(void) { return (mapTable); }
	// set
	ZafError AddPalette(ZafPaletteType type, ZafPaletteState state, ZafPaletteStruct &palette);
	virtual void Clear(void);
	virtual ZafError SetMapTable(ZafPaletteMap *paletteMap);
	virtual bool SetStaticData(bool staticData);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafData::IsA(compareName)); }

protected:
	bool staticData;
	int mapTableSize;
	ZafPaletteMap *mapTable;

	// --- Persistent members ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafPaletteData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);
};

// --- inline functions ---
inline bool ZafPaletteData::StaticData(void) const { return (staticData); }

#endif // Z_PAL1_HPP

