//	Zinc Application Framework - Z_NOTIFY.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_NOTIFY_HPP)
#define Z_NOTIFY_HPP
#include <z_env.hpp>

// --------------------------------------------------------------------------
// ----- ZafNotification ----------------------------------------------------
// --------------------------------------------------------------------------

typedef void ZafNotifyObject;

typedef int ZafUpdateType;
const ZafUpdateType ZAF_UPDATE_NONE 	= 0x0000;
const ZafUpdateType ZAF_UPDATE_DATA 	= 0x0001;
const ZafUpdateType ZAF_UPDATE_OBJECT	= 0x0002;
const ZafUpdateType ZAF_UPDATE_ALL 		= 0x0003;

typedef ZafError (*ZafUpdateFunction)(ZafNotifyObject *, ZafUpdateType);

class ZAF_EXPORT ZafNotification
{
public:
	// --- General members ---
	ZafNotification(void);
	virtual ~ZafNotification(void);
	ZafNotifyObject *AddNotification(ZafNotifyObject *object,
		ZafUpdateFunction function = ZAF_NULLF(ZafUpdateFunction),
		ZafUpdateType type = ZAF_UPDATE_ALL);
	void ClearNotifications(void);
	ZafNotifyObject *SubtractNotification(ZafNotifyObject *object,
		ZafUpdateFunction function = ZAF_NULLF(ZafUpdateFunction));
	ZafError UpdateData(ZafNotifyObject *objectSource = ZAF_NULLP(ZafNotifyObject));
	ZafError UpdateObjects(ZafNotifyObject *objectMatch = ZAF_NULLP(ZafNotifyObject));

	// --- Attributes & data access ---
	// get
	int NotifyCount(void) const;
	ZafUpdateType Update(void) const;
	ZafUpdateType Update(ZafNotifyObject *object) const;
	// set
	virtual ZafUpdateType SetUpdate(ZafUpdateType updateType);
	virtual ZafUpdateType SetUpdate(ZafNotifyObject *object, ZafUpdateType updateType);

private:
	struct NotifyObject
	{
		ZafNotifyObject *object;
		ZafUpdateFunction function;
		ZafUpdateType updateType;
	};

	ZafUpdateType updateType;
	NotifyObject *notifyArray;
};

inline ZafUpdateType ZafNotification::Update(void) const { return (updateType); }
inline ZafUpdateType ZafNotification::SetUpdate(ZafUpdateType setUpdateType) { updateType = setUpdateType; return (updateType); }

#endif // Z_NTFY_HPP

