//	Zinc Application Framework - Z_NOTEBK.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_NOTEBK_HPP)
#define Z_NOTEBK_HPP
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafNotebook --------------------------------------------------------
// --------------------------------------------------------------------------
#if defined(ZAF_MSDOS) || defined(ZAF_CURSES) || defined(ZAF_MACINTOSH)
class ZAF_EXPORT ZafNotebookTabControl;
#endif

class ZAF_EXPORT ZafNotebook : public ZafWindow
{
public:
	// --- General members ---
	ZafNotebook(int left, int top, int width, int height);
	ZafNotebook(const ZafNotebook &copy);
	~ZafNotebook(void);

	// --- Persistent members ---
	ZafNotebook(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	int CurrentPage(void) const;
	int FirstPage(void) const;
	int LastPage(void) const;
	int TabHeight(void);
	virtual const ZafIChar *TabText(int page);
	int TabWidth(void);
	// set
	virtual bool SetBordered(bool bordered);
	virtual int SetCurrentPage(int currentPage);
	virtual int SetCurrentPage(ZafWindowObject *currentPage);
	virtual ZafError SetTabText(const ZafIChar *text, int page);
	virtual int SetTabHeight(int tabHeight);
	virtual int SetTabWidth(int tabWidth);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);
	virtual ZafEventType ScrollEvent(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);

	ZafNotebook &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafNotebook &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

protected:
	friend class ZAF_EXPORT OSNotebook;

	// --- General members ---
	int tabHeight, tabWidth;
	int currentPage;

	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType DrawShadow(ZafRegionStruct &region, int depth, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);
	virtual ZafRegionStruct MaxRegion(ZafWindowObject *object,
		ZafVtJustify vWeight = ZAF_VT_TOP, ZafHzJustify hWeight = ZAF_HZ_LEFT);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafNotebook::Read); }
	virtual void WriteChildren(ZafObjectPersistence &persist);
	void WriteData(ZafObjectPersistence &persist);
	virtual void WriteSupportChildren(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafEventMap ZAF_FARDATA defaultEventMap[];

#if defined(ZAF_MSWINDOWS)
	int scrollIndex;
	ZafWindowObject *leftScrollButton;
	ZafWindowObject *rightScrollButton;
#elif defined(ZAF_MOTIF)
	ZafRegionStruct leftArrow, rightArrow;
	void DrawArrows(bool leftDepressed, bool rightDepressed);
#elif defined(ZAF_MSDOS) || defined(ZAF_CURSES) || defined(ZAF_MACINTOSH)
	ZafNotebookTabControl *tabControl;
#endif
};

// --- inline functions ---
inline int ZafNotebook::CurrentPage(void) const { return (Index(current)); }
inline int ZafNotebook::FirstPage(void) const { return (0); }
inline int ZafNotebook::LastPage(void) const { return (Count() - 1); }
inline int ZafNotebook::SetCurrentPage(ZafWindowObject *page) { return (SetCurrentPage(Index(page))); }
inline int ZafNotebook::TabHeight(void) { return (tabHeight); }
inline int ZafNotebook::TabWidth(void) { return (tabWidth); }

#endif // Z_NOTEBK_HPP

