//	Zinc Application Framework - Z_MOUSE2.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_MOUSE2_HPP)
#define Z_MOUSE2_HPP
#include <z_mouse.hpp>
#include <z_mouse1.hpp>
#include <z_device.hpp>

// --------------------------------------------------------------------------
// ----- ZafMouse -----------------------------------------------------------
// --------------------------------------------------------------------------

// --- Mouse image messages ---
const ZafDeviceImage DM_MOUSE_LAST			= -3200;
const ZafDeviceImage DM_VIEW				= -3200;
const ZafDeviceImage DM_EDIT				= -3201;
const ZafDeviceImage DM_WAIT				= -3202;
const ZafDeviceImage DM_CROSS_HAIRS			= -3203;
const ZafDeviceImage DM_MOVE				= -3204;
const ZafDeviceImage DM_LEFT_SIDE			= -3205;
const ZafDeviceImage DM_RIGHT_SIDE			= -3206;
const ZafDeviceImage DM_TOP_SIDE			= -3207;
const ZafDeviceImage DM_BOTTOM_SIDE			= -3208;
const ZafDeviceImage DM_TOP_LEFT_CORNER		= -3209;
const ZafDeviceImage DM_TOP_RIGHT_CORNER	= -3210;
const ZafDeviceImage DM_BOTTOM_LEFT_CORNER	= -3211;
const ZafDeviceImage DM_BOTTOM_RIGHT_CORNER	= -3212;
const ZafDeviceImage DM_CANCEL				= -3213;
const ZafDeviceImage DM_DRAG				= -3214;
const ZafDeviceImage DM_DRAG_MOVE			= -3215;
const ZafDeviceImage DM_DRAG_COPY			= -3216;
const ZafDeviceImage DM_DRAG_LINK			= -3217;
const ZafDeviceImage DM_DRAG_MOVE_MULTIPLE	= -3218;
const ZafDeviceImage DM_DRAG_COPY_MULTIPLE	= -3219;
const ZafDeviceImage DM_DRAG_LINK_MULTIPLE	= -3220;
const ZafDeviceImage DM_SELECT				= -3221;
const ZafDeviceImage DM_MOUSE_FIRST			= -3299;

class ZAF_EXPORT ZafMouse : public ZafDevice
{
public:
	// --- General members ---
	ZafMouse(ZafDeviceState state = D_ON, ZafDeviceImage imageType = DM_WAIT);
	ZafMouse(const ZafMouse &copy);
	virtual ~ZafMouse(void);

	// --- Attributes & data access ---
	// get
	ZafDeviceImage ImageType(void) const;
	// set
	virtual ZafDeviceImage SetImageType(ZafDeviceImage imageType);

	// --- Device members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual void Poll(void);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafDevice::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafDevice::IsA(compareName)); }

protected:
	ZafPositionStruct offset;
	ZafDeviceImage imageType;
	ZafPositionStruct position;

	// --- Image support ---
	static ZafMouseData **imageTable;
	static void ImageAllocate(void);
	static void ImageFree(bool globalRequest = false);

#if defined(ZAF_MSDOS)
public:
	void MoveMouse(int deltaX, int deltaY);
#endif
};

// --- inline functions ---
inline ZafDeviceImage ZafMouse::ImageType(void) const { return imageType; }

#endif // Z_MOUSE1_HPP

