//	Zinc Application Framework - Z_LIST.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_LIST_HPP)
#define Z_LIST_HPP
#include <z_env.hpp>
#include <z_objid.hpp>
#include <z_numid.hpp>

// --------------------------------------------------------------------------
// ----- ZafElement ---------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafElement
{
public:
	// --- General members ---
	ZafElement(void);
	virtual ~ZafElement(void);
	virtual ZafElement *Find(ZafNumberID numberID);
	virtual ZafElement *Find(ZafStringID stringID);
	int ListIndex(void) const;
	ZafElement *Next(void) const { return (next); }
	ZafNumberID NumberID(void) const { return (numberID); }
	ZafElement *Previous(void) const { return (previous); }
	ZafNumberID SetNumberID(ZafNumberID numberID);
	ZafStringID SetStringID(ZafStringID stringID);
	ZafStringID StringID(void) const { return (stringID); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : false); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : false); }
	static ZafElement *EvaluateIsA(ZafElement *element, ZafClassID compareID);

protected:
	friend class ZAF_EXPORT ZafList;

	// --- General members ---
	ZafElement *previous, *next;
	ZafNumberID numberID;
	ZafStringID stringID;
};

// --- DynamicCast ---
#if ((defined(__BCPLUSPLUS__) || defined(__TCPLUSPLUS__)) && __BORLANDC__ >= 0x460) || defined(__MWERKS__)
#	define DynamicPtrCast(arg, type) dynamic_cast<type *>(arg)
#else
#	define DynamicPtrCast(arg, type) ((type *)ZafElement::EvaluateIsA(arg, type::classID))
#endif

// --------------------------------------------------------------------------
// ----- ZafList ------------------------------------------------------------
// --------------------------------------------------------------------------

typedef int (*ZafCompareFunction)(void *, void *);

class ZAF_EXPORT ZafList
{
public:
	ZafList(ZafCompareFunction compareFunction = ZAF_NULLF(ZafCompareFunction));
	virtual ~ZafList(void);
	ZafElement *Add(ZafElement *newElement);
	ZafElement *Add(ZafElement *element, ZafElement *position);
	virtual ZafCompareFunction CompareFunction(void) const;
	int Count(void) const;
	ZafElement *Current(void) const { return (current); }
	virtual void Destroy(void);
	ZafElement *Find(ZafNumberID numberID);
	ZafElement *Find(const ZafIChar *stringID);
	ZafElement *First(void) const { return (first); }
	ZafElement *Get(int index);
	ZafElement *Get(int (*findFunction)(void *element1, void *matchData), void *matchData);
	int Index(ZafElement const *element) const;
	ZafElement *Last(void) const { return (last); }
	virtual ZafCompareFunction SetCompareFunction(ZafCompareFunction compareFunction);
	void SetCurrent(ZafElement *element) { current = element; }
	virtual void Sort(void);
	ZafElement *Subtract(ZafElement *element);

	ZafList &operator+(ZafElement *element) { Add(element); return(*this); }
	ZafList &operator-(ZafElement *element) { Subtract(element); return(*this); }
	ZafElement *operator()(int index) { return((ZafElement *)ZafList::Get(index)); }

protected:
	friend class ZAF_EXPORT ZafListBlock;

	// --- General members ---
	ZafCompareFunction compareFunction;
	ZafElement *first, *last, *current;
};

// --------------------------------------------------------------------------
// ----- ZafListBlock -------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafListBlock : public ZafList
{
public:
	// --- General members ---
	ZafListBlock(int noOfElements, ZafCompareFunction compareFunction = ZAF_NULLF(ZafCompareFunction));
	virtual ~ZafListBlock(void);
	ZafElement *Add(void);
	ZafElement *Add(ZafElement *element);
	ZafElement *Subtract(ZafElement *element);

	// --- Attributes ---
	bool Full(void) const { return (freeList.First() ? false : true); }

protected:
	int noOfElements;
	void *elementArray;
	ZafList freeList;
};

#endif // Z_LIST_HPP

