//	Zinc Application Framework - Z_LANG.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_LANG_HPP)
#define Z_LANG_HPP
#include <z_idata.hpp>

// --------------------------------------------------------------------------
// ----- ZafLanguageData ----------------------------------------------------
// --------------------------------------------------------------------------

struct ZAF_EXPORT ZafLanguageStruct
{
	ZafIChar *text;
	ZafNumberID numberID;
	ZafIChar *stringID;
	ZafIChar hotKeyChar;
	int hotKeyIndex;
};

class ZAF_EXPORT ZafLanguageData : public ZafI18nData
{
public:
	static ZafIChar blankString[];
	static ZafIChar errorString[];

	// --- General members ---
	ZafLanguageData(bool staticData = false);
	ZafLanguageData(ZafLanguageStruct *data, bool staticData = false);
	ZafLanguageData(const ZafLanguageData &copy);
	virtual ~ZafLanguageData(void);

	// --- Persistent members ---
	ZafLanguageData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	operator ZafLanguageStruct *() { return (data); }
	// get
	ZafIChar *GetMessage(ZafNumberID numberID, bool useDefault = false,
		ZafIChar *hotKeyChar = ZAF_NULLP(ZafIChar),
		int *hotKeyIndex = ZAF_NULLP(int)) const;
	static const ZafIChar *LanguageName(void);
	bool StaticData(void) const;
	// set
	virtual void Clear(void);
	virtual ZafError SetMessage(ZafNumberID numberID, ZafIChar *text,
		ZafIChar hotKeyChar = 0, int hotKeyIndex = -1);
	virtual ZafError SetLanguage(ZafLanguageStruct *value);
	virtual ZafError SetLanguage(const ZafLanguageData &data);
	static ZafError SetLanguageName(const ZafIChar *languageName);
	virtual bool SetStaticData(bool staticData);

	// --- Default locale ---
	static void LanguageAllocate(const ZafIChar *name = ZAF_NULLP(ZafIChar));
	static void LanguageFree(bool globalRequest = false);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafI18nData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafI18nData::IsA(compareName)); }

protected:
	bool staticData;
	ZafLanguageStruct *data;

	// --- Persistent members ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafLanguageData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);
};

extern ZAF_EXPORT ZafLanguageData *zafLanguage;

// --- inline functions ---
inline const ZafIChar *ZafLanguageData::LanguageName(void) { return (zafLanguage ? zafLanguage->StringID() : ZAF_NULLP(ZafIChar)); }
inline bool ZafLanguageData::StaticData(void) const { return (staticData); }

#endif // Z_LANG_HPP

