//	Zinc Application Framework - Z_KEYMAP.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// ----- Include file and environment definition ----------------------------

#if !defined(Z_KEYMAP_HPP)
#define Z_KEYMAP_HPP
#include <z_env.hpp>

// ----- Special hotkey values ----------------------------------------------

const ZafIChar ZAF_HOT_KEY_MAXIMIZE		= (ZafIChar)252;
const ZafIChar ZAF_HOT_KEY_MINIMIZE		= (ZafIChar)253;
const ZafIChar ZAF_HOT_KEY_SYSTEM		= (ZafIChar)254;
const ZafIChar ZAF_HOT_KEY_SUB_WINDOW	= (ZafIChar)255;

// --------------------------------------------------------------------------
// ----- ZAF_MSDOS ----------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZAF_MSDOS)
const ZafRawCode ESCAPE					= 0x011B;	// Miscellaneous keys
const ZafRawCode ENTER					= 0x1C0D;
const ZafRawCode CTRL_ENTER				= 0x1C0A;
const ZafRawCode SPACE					= 0x3920;
const ZafRawCode BACKSPACE				= 0x0E08;
const ZafRawCode CTRL_BACKSPACE			= 0x0E7F;
const ZafRawCode ALT_BACKSPACE			= 0x0E00;
const ZafRawCode TAB					= 0x0F09;
const ZafRawCode CTRL_TAB				= 0x9400;
const ZafRawCode BACKTAB				= 0x0F00;

const ZafRawCode CTRL_BREAK				= 0x0000;
const ZafRawCode CTRL_C					= 0x2E03;

const ZafRawCode ALT_ESCAPE				= 0x0100;
const ZafRawCode ALT_PERIOD				= 0x3400;
const ZafRawCode ALT_SPACE				= 0x3920;
const ZafRawCode ALT_WHITE_MINUS		= 0x8200;
const ZafRawCode ALT_WHITE_PLUS			= 0x8300;

const ZafRawCode ALT_A					= 0x1E00;
const ZafRawCode ALT_B					= 0x3000;
const ZafRawCode ALT_C					= 0x2E00;
const ZafRawCode ALT_D					= 0x2000;
const ZafRawCode ALT_E					= 0x1200;
const ZafRawCode ALT_F					= 0x2100;
const ZafRawCode ALT_G					= 0x2200;
const ZafRawCode ALT_H					= 0x2300;
const ZafRawCode ALT_I					= 0x1700;
const ZafRawCode ALT_J					= 0x2400;
const ZafRawCode ALT_K					= 0x2500;
const ZafRawCode ALT_L					= 0x2600;
const ZafRawCode ALT_M					= 0x3200;
const ZafRawCode ALT_N					= 0x3100;
const ZafRawCode ALT_O					= 0x1800;
const ZafRawCode ALT_P					= 0x1900;
const ZafRawCode ALT_Q					= 0x1000;
const ZafRawCode ALT_R					= 0x1300;
const ZafRawCode ALT_S					= 0x1F00;
const ZafRawCode ALT_T					= 0x1400;
const ZafRawCode ALT_U					= 0x1600;
const ZafRawCode ALT_V					= 0x2F00;
const ZafRawCode ALT_W					= 0x1100;
const ZafRawCode ALT_X					= 0x2D00;
const ZafRawCode ALT_Y					= 0x1500;
const ZafRawCode ALT_Z					= 0x2C00;

const ZafRawCode ALT_1					= 0x7800;
const ZafRawCode ALT_2					= 0x7900;
const ZafRawCode ALT_3					= 0x7A00;
const ZafRawCode ALT_4					= 0x7B00;
const ZafRawCode ALT_5					= 0x7C00;
const ZafRawCode ALT_6					= 0x7D00;
const ZafRawCode ALT_7					= 0x7E00;
const ZafRawCode ALT_8					= 0x7F00;
const ZafRawCode ALT_9					= 0x8000;
const ZafRawCode ALT_0					= 0x8100;

const ZafRawCode GRAY_ENTER				= 0xE00D;	// Gray keys
const ZafRawCode GRAY_CTRL_ENTER	  	= 0xE00A;
const ZafRawCode GRAY_UP_ARROW			= 0x48E0;
const ZafRawCode GRAY_DOWN_ARROW		= 0x50E0;
const ZafRawCode GRAY_LEFT_ARROW		= 0x4BE0;
const ZafRawCode GRAY_RIGHT_ARROW		= 0x4DE0;
const ZafRawCode GRAY_INSERT			= 0x52E0;
const ZafRawCode GRAY_DELETE			= 0x53E0;
const ZafRawCode GRAY_HOME				= 0x47E0;
const ZafRawCode GRAY_END				= 0x4FE0;
const ZafRawCode GRAY_PGUP				= 0x49E0;
const ZafRawCode GRAY_PGDN				= 0x51E0;
const ZafRawCode GRAY_DIVIDE			= 0xE02F;
const ZafRawCode GRAY_MULTIPLY			= 0x372A;
const ZafRawCode GRAY_PLUS				= 0x4E2B;
const ZafRawCode GRAY_MINUS				= 0x4A2D;

const ZafRawCode CTRL_GRAY_UP_ARROW		= 0x8DE0;
const ZafRawCode CTRL_GRAY_DOWN_ARROW	= 0x91E0;
const ZafRawCode CTRL_GRAY_LEFT_ARROW	= 0x73E0;
const ZafRawCode CTRL_GRAY_RIGHT_ARROW	= 0x74E0;
const ZafRawCode CTRL_GRAY_INSERT		= 0x92E0;
const ZafRawCode CTRL_GRAY_DELETE		= 0x93E0;
const ZafRawCode CTRL_GRAY_HOME			= 0x77E0;
const ZafRawCode CTRL_GRAY_END			= 0x75E0;
const ZafRawCode CTRL_GRAY_PGUP			= 0x84E0;
const ZafRawCode CTRL_GRAY_PGDN			= 0x76E0;
const ZafRawCode CTRL_GRAY_DIVIDE		= 0x9500;
const ZafRawCode CTRL_GRAY_MULTIPLY		= 0x9600;
const ZafRawCode CTRL_GRAY_PLUS			= 0x9000;
const ZafRawCode CTRL_GRAY_MINUS		= 0x8E00;

const ZafRawCode ALT_GRAY_UP_ARROW		= 0x9800;
const ZafRawCode ALT_GRAY_DOWN_ARROW	= 0xA000;
const ZafRawCode ALT_GRAY_LEFT_ARROW	= 0x9B00;
const ZafRawCode ALT_GRAY_RIGHT_ARROW	= 0x9D00;
const ZafRawCode ALT_GRAY_INSERT		= 0xA200;
const ZafRawCode ALT_GRAY_DELETE		= 0xA300;
const ZafRawCode ALT_GRAY_HOME			= 0x9700;
const ZafRawCode ALT_GRAY_END			= 0x9F00;
const ZafRawCode ALT_GRAY_PGUP			= 0x9900;
const ZafRawCode ALT_GRAY_PGDN			= 0xA100;
const ZafRawCode ALT_GRAY_DIVIDE		= 0xA400;
const ZafRawCode ALT_GRAY_MULTIPLY		= 0x3700;
const ZafRawCode ALT_GRAY_PLUS			= 0x4E00;
const ZafRawCode ALT_GRAY_MINUS			= 0x4A00;

const ZafRawCode WHITE_UP_ARROW			= 0x4800;	// White keys
const ZafRawCode WHITE_DOWN_ARROW		= 0x5000;
const ZafRawCode WHITE_LEFT_ARROW		= 0x4B00;
const ZafRawCode WHITE_RIGHT_ARROW		= 0x4D00;
const ZafRawCode WHITE_INSERT			= 0x5200;
const ZafRawCode WHITE_DELETE			= 0x5300;
const ZafRawCode WHITE_HOME				= 0x4700;
const ZafRawCode WHITE_END				= 0x4F00;
const ZafRawCode WHITE_PGUP				= 0x4900;
const ZafRawCode WHITE_PGDN				= 0x5100;
const ZafRawCode WHITE_CENTER			= 0x4C00;

const ZafRawCode SHIFT_WHITE_UP_ARROW	= 0x4838;
const ZafRawCode SHIFT_WHITE_DOWN_ARROW	= 0x5032;
const ZafRawCode SHIFT_WHITE_LEFT_ARROW	= 0x4B34;
const ZafRawCode SHIFT_WHITE_RIGHT_ARROW= 0x4D36;
const ZafRawCode SHIFT_WHITE_INSERT		= 0x5230;
const ZafRawCode SHIFT_WHITE_DELETE		= 0x532E;
const ZafRawCode SHIFT_WHITE_HOME		= 0x4737;
const ZafRawCode SHIFT_WHITE_END		= 0x4F31;
const ZafRawCode SHIFT_WHITE_PGUP		= 0x4939;
const ZafRawCode SHIFT_WHITE_PGDN		= 0x5133;

const ZafRawCode CTRL_WHITE_UP_ARROW	= 0x8D00;
const ZafRawCode CTRL_WHITE_DOWN_ARROW	= 0x9100;
const ZafRawCode CTRL_WHITE_LEFT_ARROW	= 0x7300;
const ZafRawCode CTRL_WHITE_RIGHT_ARROW	= 0x7400;
const ZafRawCode CTRL_WHITE_INSERT		= 0x9200;
const ZafRawCode CTRL_WHITE_DELETE		= 0x9300;
const ZafRawCode CTRL_WHITE_HOME		= 0x7700;
const ZafRawCode CTRL_WHITE_END			= 0x7500;
const ZafRawCode CTRL_WHITE_PGUP		= 0x8400;
const ZafRawCode CTRL_WHITE_PGDN		= 0x7600;
const ZafRawCode CTRL_WHITE_CENTER		= 0x8F00;

const ZafRawCode F1						= 0x3B00;	// Function keys
const ZafRawCode F2						= 0x3C00;
const ZafRawCode F3						= 0x3D00;
const ZafRawCode F4						= 0x3E00;
const ZafRawCode F5						= 0x3F00;
const ZafRawCode F6						= 0x4000;
const ZafRawCode F7						= 0x4100;
const ZafRawCode F8						= 0x4200;
const ZafRawCode F9						= 0x4300;
const ZafRawCode F10					= 0x4400;
const ZafRawCode F11					= 0x8500;
const ZafRawCode F12					= 0x8600;

const ZafRawCode SHIFT_F1				= 0x5400;
const ZafRawCode SHIFT_F2				= 0x5500;
const ZafRawCode SHIFT_F3				= 0x5600;
const ZafRawCode SHIFT_F4				= 0x5700;
const ZafRawCode SHIFT_F5				= 0x5800;
const ZafRawCode SHIFT_F6				= 0x5900;
const ZafRawCode SHIFT_F7				= 0x5A00;
const ZafRawCode SHIFT_F8				= 0x5B00;
const ZafRawCode SHIFT_F9				= 0x5C00;
const ZafRawCode SHIFT_F10				= 0x5D00;
const ZafRawCode SHIFT_F11				= 0x8700;
const ZafRawCode SHIFT_F12				= 0x8800;

const ZafRawCode CTRL_F1				= 0x5E00;
const ZafRawCode CTRL_F2				= 0x5F00;
const ZafRawCode CTRL_F3				= 0x6000;
const ZafRawCode CTRL_F4				= 0x6100;
const ZafRawCode CTRL_F5				= 0x6200;
const ZafRawCode CTRL_F6				= 0x6300;
const ZafRawCode CTRL_F7				= 0x6400;
const ZafRawCode CTRL_F8				= 0x6500;
const ZafRawCode CTRL_F9				= 0x6600;
const ZafRawCode CTRL_F10				= 0x6700;
const ZafRawCode CTRL_F11				= 0x8900;
const ZafRawCode CTRL_F12				= 0x8A00;

const ZafRawCode ALT_F1					= 0x6800;
const ZafRawCode ALT_F2					= 0x6900;
const ZafRawCode ALT_F3					= 0x6A00;
const ZafRawCode ALT_F4					= 0x6B00;
const ZafRawCode ALT_F5					= 0x6C00;
const ZafRawCode ALT_F6					= 0x6D00;
const ZafRawCode ALT_F7					= 0x6E00;
const ZafRawCode ALT_F8					= 0x6F00;
const ZafRawCode ALT_F9					= 0x7000;
const ZafRawCode ALT_F10				= 0x7100;
const ZafRawCode ALT_F11				= 0x8B00;
const ZafRawCode ALT_F12				= 0x8C00;
const ZafRawCode Z_DONT_USE				= 0xFFFF;
#endif

// --------------------------------------------------------------------------
// ----- ZAF_MSWINDOWS ------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZAF_MSWINDOWS)
const ZafRawCode ESCAPE					= 0x001B;	// Miscellaneous keys
const ZafRawCode ENTER					= 0x000D;
const ZafRawCode CTRL_ENTER				= 0x040A;
const ZafRawCode SPACE					= 0x0020;
const ZafRawCode SHIFT_SPACE			= 0x0320;
const ZafRawCode CTRL_SPACE				= 0x0420;
const ZafRawCode BACKSPACE				= 0x0008;
const ZafRawCode CTRL_BACKSPACE			= 0x0408;
const ZafRawCode ALT_BACKSPACE			= 0x0808;
const ZafRawCode TAB					= 0x0009;
const ZafRawCode CTRL_TAB				= 0x0409;
const ZafRawCode BACKTAB				= 0x0309;

const ZafRawCode CTRL_BREAK				= 0x0403;
const ZafRawCode CTRL_C					= 0x0443;

const ZafRawCode ALT_ESCAPE				= 0x081B;
const ZafRawCode ALT_PERIOD				= 0x08BE;
const ZafRawCode ALT_SPACE				= 0x0820;
const ZafRawCode ALT_WHITE_MINUS		= 0x082D;
const ZafRawCode ALT_WHITE_PLUS			= 0x082B;

const ZafRawCode ALT_A					= 0x0861;
const ZafRawCode ALT_B					= 0x0862;
const ZafRawCode ALT_C					= 0x0863;
const ZafRawCode ALT_D					= 0x0864;
const ZafRawCode ALT_E					= 0x0865;
const ZafRawCode ALT_F					= 0x0866;
const ZafRawCode ALT_G					= 0x0867;
const ZafRawCode ALT_H					= 0x0868;
const ZafRawCode ALT_I					= 0x0869;
const ZafRawCode ALT_J					= 0x086A;
const ZafRawCode ALT_K					= 0x086B;
const ZafRawCode ALT_L					= 0x086C;
const ZafRawCode ALT_M					= 0x086D;
const ZafRawCode ALT_N					= 0x086E;
const ZafRawCode ALT_O					= 0x086F;
const ZafRawCode ALT_P					= 0x0870;
const ZafRawCode ALT_Q					= 0x0871;
const ZafRawCode ALT_R					= 0x0872;
const ZafRawCode ALT_S					= 0x0873;
const ZafRawCode ALT_T					= 0x0874;
const ZafRawCode ALT_U					= 0x0875;
const ZafRawCode ALT_V					= 0x0876;
const ZafRawCode ALT_W					= 0x0877;
const ZafRawCode ALT_X					= 0x0878;
const ZafRawCode ALT_Y					= 0x0879;
const ZafRawCode ALT_Z					= 0x087A;

const ZafRawCode ALT_A_GRAVE			= 0x08E0;
const ZafRawCode ALT_A_ACUTE			= 0x08E1;
const ZafRawCode ALT_A_CIRCUMFLEX		= 0x08E2;
const ZafRawCode ALT_A_TILDE			= 0x08E3;
const ZafRawCode ALT_A_DIARESIS			= 0x08E4;
const ZafRawCode ALT_A_RING				= 0x08E5;
const ZafRawCode ALT_A_E				= 0x08E6;
const ZafRawCode ALT_C_CEDILLA			= 0x08E7;
const ZafRawCode ALT_E_GRAVE			= 0x08E8;
const ZafRawCode ALT_E_ACUTE			= 0x08E9;
const ZafRawCode ALT_E_CIRCUMFLEX		= 0x08EA;
const ZafRawCode ALT_E_DIARESIS			= 0x08EB;
const ZafRawCode ALT_I_GRAVE			= 0x08EC;
const ZafRawCode ALT_I_ACUTE			= 0x08ED;
const ZafRawCode ALT_I_CIRCUMFLEX		= 0x08EE;
const ZafRawCode ALT_I_DIARESIS			= 0x08EF;
const ZafRawCode ALT_ETH				= 0x08F0;
const ZafRawCode ALT_N_TILDE			= 0x08F1;
const ZafRawCode ALT_O_GRAVE			= 0x08F2;
const ZafRawCode ALT_O_ACUTE			= 0x08F3;
const ZafRawCode ALT_O_CIRCUMFLEX		= 0x08F4;
const ZafRawCode ALT_O_TILDE			= 0x08F5;
const ZafRawCode ALT_O_DIARESIS			= 0x08F6;
const ZafRawCode ALT_O_SLASH			= 0x08F8;
const ZafRawCode ALT_U_GRAVE			= 0x08F9;
const ZafRawCode ALT_U_ACUTE			= 0x08FA;
const ZafRawCode ALT_U_CIRCUMFLEX		= 0x08FB;
const ZafRawCode ALT_U_DIARESIS			= 0x08FC;
const ZafRawCode ALT_Y_ACUTE			= 0x08FD;
const ZafRawCode ALT_THORN				= 0x08FE;

const ZafRawCode ALT_1					= 0x0831;
const ZafRawCode ALT_2					= 0x0832;
const ZafRawCode ALT_3					= 0x0833;
const ZafRawCode ALT_4					= 0x0834;
const ZafRawCode ALT_5					= 0x0835;
const ZafRawCode ALT_6					= 0x0836;
const ZafRawCode ALT_7					= 0x0837;
const ZafRawCode ALT_8					= 0x0838;
const ZafRawCode ALT_9					= 0x0839;
const ZafRawCode ALT_0					= 0x0840;

const ZafRawCode GRAY_ENTER				= 0x000D;	// Gray keys
const ZafRawCode GRAY_UP_ARROW			= 0x0026;
const ZafRawCode GRAY_DOWN_ARROW		= 0x0028;
const ZafRawCode GRAY_LEFT_ARROW		= 0x0025;
const ZafRawCode GRAY_RIGHT_ARROW		= 0x0027;
const ZafRawCode GRAY_INSERT			= 0x802D;
const ZafRawCode GRAY_DELETE			= 0x002E;
const ZafRawCode GRAY_HOME				= 0x0024;
const ZafRawCode GRAY_END				= 0x0023;
const ZafRawCode GRAY_PGUP				= 0x0021;
const ZafRawCode GRAY_PGDN				= 0x0022;
const ZafRawCode GRAY_DIVIDE			= 0x006F;
const ZafRawCode GRAY_MULTIPLY			= 0x006A;
const ZafRawCode GRAY_PLUS				= 0x006B;
const ZafRawCode GRAY_MINUS				= 0x006D;

const ZafRawCode CTRL_GRAY_UP_ARROW		= 0x0426;
const ZafRawCode CTRL_GRAY_DOWN_ARROW	= 0x0428;
const ZafRawCode CTRL_GRAY_LEFT_ARROW	= 0x0425;
const ZafRawCode CTRL_GRAY_RIGHT_ARROW	= 0x0427;
const ZafRawCode CTRL_GRAY_INSERT		= 0x842D;
const ZafRawCode CTRL_GRAY_DELETE		= 0x042E;
const ZafRawCode CTRL_GRAY_HOME			= 0x0424;
const ZafRawCode CTRL_GRAY_END			= 0x0423;
const ZafRawCode CTRL_GRAY_PGUP			= 0x0421;
const ZafRawCode CTRL_GRAY_PGDN			= 0x0422;
const ZafRawCode CTRL_GRAY_DIVIDE		= 0x046F;
const ZafRawCode CTRL_GRAY_MULTIPLY		= 0x046A;
const ZafRawCode CTRL_GRAY_PLUS			= 0x046B;
const ZafRawCode CTRL_GRAY_MINUS		= 0x046D;

const ZafRawCode ALT_GRAY_UP_ARROW		= 0x0826;
const ZafRawCode ALT_GRAY_DOWN_ARROW	= 0x0828;
const ZafRawCode ALT_GRAY_LEFT_ARROW	= 0x0825;
const ZafRawCode ALT_GRAY_RIGHT_ARROW	= 0x0827;
const ZafRawCode ALT_GRAY_INSERT		= 0x882D;
const ZafRawCode ALT_GRAY_DELETE		= 0x082E;
const ZafRawCode ALT_GRAY_HOME			= 0x0824;
const ZafRawCode ALT_GRAY_END			= 0x0823;
const ZafRawCode ALT_GRAY_PGUP			= 0x0821;
const ZafRawCode ALT_GRAY_PGDN			= 0x0822;
const ZafRawCode ALT_GRAY_DIVIDE		= 0x086F;
const ZafRawCode ALT_GRAY_MULTIPLY		= 0x086A;
const ZafRawCode ALT_GRAY_PLUS			= 0x086B;
const ZafRawCode ALT_GRAY_MINUS			= 0x086D;

const ZafRawCode WHITE_UP_ARROW			= 0x0026;	// White keys
const ZafRawCode WHITE_DOWN_ARROW		= 0x0028;
const ZafRawCode WHITE_LEFT_ARROW		= 0x0025;
const ZafRawCode WHITE_RIGHT_ARROW		= 0x0027;
const ZafRawCode WHITE_INSERT			= 0x802D;
const ZafRawCode WHITE_DELETE			= 0x002E;
const ZafRawCode WHITE_HOME				= 0x0024;
const ZafRawCode WHITE_END				= 0x0023;
const ZafRawCode WHITE_PGUP				= 0x0021;
const ZafRawCode WHITE_PGDN				= 0x0022;
const ZafRawCode WHITE_CENTER			= 0x002A;

const ZafRawCode CTRL_WHITE_UP_ARROW	= 0x0426;
const ZafRawCode CTRL_WHITE_DOWN_ARROW	= 0x0428;
const ZafRawCode CTRL_WHITE_LEFT_ARROW	= 0x0425;
const ZafRawCode CTRL_WHITE_RIGHT_ARROW	= 0x0427;
const ZafRawCode CTRL_WHITE_INSERT		= 0x842D;
const ZafRawCode CTRL_WHITE_DELETE		= 0x042E;
const ZafRawCode CTRL_WHITE_HOME		= 0x0424;
const ZafRawCode CTRL_WHITE_END			= 0x0423;
const ZafRawCode CTRL_WHITE_PGUP		= 0x0421;
const ZafRawCode CTRL_WHITE_PGDN		= 0x0422;
const ZafRawCode CTRL_WHITE_CENTER		= 0x042A;

const ZafRawCode F1						= 0x0070;	// Function keys
const ZafRawCode F2						= 0x0071;
const ZafRawCode F3						= 0x0072;
const ZafRawCode F4						= 0x0073;
const ZafRawCode F5						= 0x0074;
const ZafRawCode F6						= 0x0075;
const ZafRawCode F7						= 0x0076;
const ZafRawCode F8						= 0x0077;
const ZafRawCode F9						= 0x0078;
const ZafRawCode F10					= 0x0079;
const ZafRawCode F11					= 0x007A;
const ZafRawCode F12					= 0x007B;

const ZafRawCode SHIFT_F1				= 0x0370;
const ZafRawCode SHIFT_F2				= 0x0371;
const ZafRawCode SHIFT_F3				= 0x0372;
const ZafRawCode SHIFT_F4				= 0x0373;
const ZafRawCode SHIFT_F5				= 0x0374;
const ZafRawCode SHIFT_F6				= 0x0375;
const ZafRawCode SHIFT_F7				= 0x0376;
const ZafRawCode SHIFT_F8				= 0x0377;
const ZafRawCode SHIFT_F9				= 0x0378;
const ZafRawCode SHIFT_F10				= 0x0379;
const ZafRawCode SHIFT_F11				= 0x037A;
const ZafRawCode SHIFT_F12				= 0x037B;

const ZafRawCode CTRL_F1				= 0x0470;
const ZafRawCode CTRL_F2				= 0x0471;
const ZafRawCode CTRL_F3				= 0x0472;
const ZafRawCode CTRL_F4				= 0x0473;
const ZafRawCode CTRL_F5				= 0x0474;
const ZafRawCode CTRL_F6				= 0x0475;
const ZafRawCode CTRL_F7				= 0x0476;
const ZafRawCode CTRL_F8				= 0x0477;
const ZafRawCode CTRL_F9				= 0x0478;
const ZafRawCode CTRL_F10				= 0x0479;
const ZafRawCode CTRL_F11				= 0x047A;
const ZafRawCode CTRL_F12				= 0x047B;

const ZafRawCode ALT_F1					= 0x0870;
const ZafRawCode ALT_F2					= 0x0871;
const ZafRawCode ALT_F3					= 0x0872;
const ZafRawCode ALT_F4					= 0x0873;
const ZafRawCode ALT_F5					= 0x0874;
const ZafRawCode ALT_F6					= 0x0875;
const ZafRawCode ALT_F7					= 0x0876;
const ZafRawCode ALT_F8					= 0x0877;
const ZafRawCode ALT_F9					= 0x0878;
const ZafRawCode ALT_F10				= 0x0879;
const ZafRawCode ALT_F11				= 0x087A;
const ZafRawCode ALT_F12				= 0x087B;
#endif

// --------------------------------------------------------------------------
// ----- ZAF_OS2 ------------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZAF_OS2)
const ZafRawCode ESCAPE					= 0x01000000;
const ZafRawCode ENTER					= 0x1C000000;
const ZafRawCode SPACE					= 0x39000000;
const ZafRawCode BACKSPACE	   			= 0x0E000000;
const ZafRawCode CTRL_BACKSPACE			= 0x0E000004;
const ZafRawCode ALT_BACKSPACE			= 0x0E000008;
const ZafRawCode TAB					= 0x0F000000;
const ZafRawCode CTRL_TAB				= 0x0F000004;
const ZafRawCode BACKTAB				= 0x0F000003;

const ZafRawCode CTRL_BREAK				= 0x5F000004;
const ZafRawCode CTRL_C					= 0x2E000004;

const ZafRawCode ALT_ESCAPE				= 0x01000008;
const ZafRawCode ALT_PERIOD				= 0x34000008;
const ZafRawCode ALT_SPACE	   			= 0x39000008;
const ZafRawCode ALT_WHITE_MINUS		= 0x0C000008;
const ZafRawCode ALT_WHITE_PLUS			= 0x0D00000B;

const ZafRawCode ALT_A					= 0x1E000008;
const ZafRawCode ALT_B					= 0x30000008;
const ZafRawCode ALT_C					= 0x2E000008;
const ZafRawCode ALT_D					= 0x20000008;
const ZafRawCode ALT_E					= 0x12000008;
const ZafRawCode ALT_F					= 0x21000008;
const ZafRawCode ALT_G					= 0x22000008;
const ZafRawCode ALT_H					= 0x23000008;
const ZafRawCode ALT_I					= 0x17000008;
const ZafRawCode ALT_J					= 0x24000008;
const ZafRawCode ALT_K					= 0x25000008;
const ZafRawCode ALT_L					= 0x26000008;
const ZafRawCode ALT_M					= 0x32000008;
const ZafRawCode ALT_N					= 0x31000008;
const ZafRawCode ALT_O					= 0x18000008;
const ZafRawCode ALT_P					= 0x19000008;
const ZafRawCode ALT_Q					= 0x10000008;
const ZafRawCode ALT_R					= 0x13000008;
const ZafRawCode ALT_S					= 0x1F000008;
const ZafRawCode ALT_T					= 0x14000008;
const ZafRawCode ALT_U					= 0x16000008;
const ZafRawCode ALT_V					= 0x2F000008;
const ZafRawCode ALT_W					= 0x11000008;
const ZafRawCode ALT_X					= 0x2D000008;
const ZafRawCode ALT_Y					= 0x15000008;
const ZafRawCode ALT_Z					= 0x2C000008;

const ZafRawCode ALT_1					= 0x02000008;
const ZafRawCode ALT_2					= 0x03000008;
const ZafRawCode ALT_3					= 0x04000008;
const ZafRawCode ALT_4					= 0x05000008;
const ZafRawCode ALT_5					= 0x06000008;
const ZafRawCode ALT_6					= 0x07000008;
const ZafRawCode ALT_7					= 0x08000008;
const ZafRawCode ALT_8					= 0x09000008;
const ZafRawCode ALT_9					= 0x0A000008;
const ZafRawCode ALT_0					= 0x0B000008;

const ZafRawCode GRAY_ENTER				= 0x5A000000;
const ZafRawCode GRAY_UP_ARROW			= 0x61000000;
const ZafRawCode GRAY_DOWN_ARROW		= 0x66000000;
const ZafRawCode GRAY_LEFT_ARROW		= 0x63000000;
const ZafRawCode GRAY_RIGHT_ARROW		= 0x64000000;
const ZafRawCode GRAY_INSERT			= 0x68000000;
const ZafRawCode GRAY_DELETE			= 0x69000000;
const ZafRawCode GRAY_HOME	    	  	= 0x60000000;
const ZafRawCode GRAY_END				= 0x65000000;
const ZafRawCode GRAY_PGUP	      		= 0x62000000;
const ZafRawCode GRAY_PGDN	      		= 0x67000000;
const ZafRawCode GRAY_DIVIDE			= 0x5C000000;
const ZafRawCode GRAY_MULTIPLY			= 0x37000000;
const ZafRawCode GRAY_PLUS	      		= 0x4E000000;
const ZafRawCode GRAY_MINUS				= 0x4A000000;
											
const ZafRawCode CTRL_GRAY_UP_ARROW		= 0x61000004;
const ZafRawCode CTRL_GRAY_DOWN_ARROW	= 0x66000004;
const ZafRawCode CTRL_GRAY_LEFT_ARROW	= 0x63000004;
const ZafRawCode CTRL_GRAY_RIGHT_ARROW	= 0x64000004;
const ZafRawCode CTRL_GRAY_INSERT		= 0x68000004;
const ZafRawCode CTRL_GRAY_DELETE		= 0x69000004;
const ZafRawCode CTRL_GRAY_HOME			= 0x60000004;
const ZafRawCode CTRL_GRAY_END			= 0x65000004;
const ZafRawCode CTRL_GRAY_PGUP			= 0x62000004;
const ZafRawCode CTRL_GRAY_PGDN			= 0x67000004;
const ZafRawCode CTRL_GRAY_DIVIDE		= 0x5C000004;
const ZafRawCode CTRL_GRAY_MULTIPLY		= 0x37000004;
const ZafRawCode CTRL_GRAY_PLUS			= 0x4E000004;
const ZafRawCode CTRL_GRAY_MINUS		= 0x4A000004;

const ZafRawCode ALT_GRAY_UP_ARROW      = 0x61000008;
const ZafRawCode ALT_GRAY_DOWN_ARROW	= 0x66000008;
const ZafRawCode ALT_GRAY_LEFT_ARROW	= 0x63000008;
const ZafRawCode ALT_GRAY_RIGHT_ARROW	= 0x64000008;
const ZafRawCode ALT_GRAY_INSERT		= 0x68000008;
const ZafRawCode ALT_GRAY_DELETE		= 0x69000008;
const ZafRawCode ALT_GRAY_HOME			= 0x60000008;
const ZafRawCode ALT_GRAY_END			= 0x65000008;
const ZafRawCode ALT_GRAY_PGUP			= 0x62000008;
const ZafRawCode ALT_GRAY_PGDN			= 0x67000008;
const ZafRawCode ALT_GRAY_DIVIDE		= 0x5C000008;
const ZafRawCode ALT_GRAY_MULTIPLY      = 0x37000008;
const ZafRawCode ALT_GRAY_PLUS			= 0x4E000008;
const ZafRawCode ALT_GRAY_MINUS			= 0x4A000008;

const ZafRawCode WHITE_UP_ARROW			= 0x48000000;
const ZafRawCode WHITE_DOWN_ARROW		= 0x50000000;
const ZafRawCode WHITE_LEFT_ARROW		= 0x4B000000;
const ZafRawCode WHITE_RIGHT_ARROW      = 0x4D000000;
const ZafRawCode WHITE_INSERT			= 0x52000000;
const ZafRawCode WHITE_DELETE			= 0x53000000;
const ZafRawCode WHITE_HOME				= 0x47000000;
const ZafRawCode WHITE_END	      		= 0x4F000000;
const ZafRawCode WHITE_PGUP				= 0x49000000;
const ZafRawCode WHITE_PGDN				= 0x51000000;
const ZafRawCode WHITE_CENTER			= 0x4C000000;

const ZafRawCode CTRL_WHITE_UP_ARROW	= 0x48000004;
const ZafRawCode CTRL_WHITE_DOWN_ARROW	= 0x50000004;
const ZafRawCode CTRL_WHITE_LEFT_ARROW	= 0x4B000004;
const ZafRawCode CTRL_WHITE_RIGHT_ARROW	= 0x4D000004;
const ZafRawCode CTRL_WHITE_INSERT		= 0x52000004;
const ZafRawCode CTRL_WHITE_DELETE		= 0x53000004;
const ZafRawCode CTRL_WHITE_HOME		= 0x47000004;
const ZafRawCode CTRL_WHITE_END			= 0x4F000004;
const ZafRawCode CTRL_WHITE_PGUP		= 0x49000004;
const ZafRawCode CTRL_WHITE_PGDN		= 0x51000004;
const ZafRawCode CTRL_WHITE_CENTER		= 0x4C000004;

const ZafRawCode F1						= 0x3B000000;
const ZafRawCode F2						= 0x3C000000;
const ZafRawCode F3						= 0x3D000000;
const ZafRawCode F4						= 0x3E000000;
const ZafRawCode F5						= 0x3F000000;
const ZafRawCode F6						= 0x40000000;
const ZafRawCode F7						= 0x41000000;
const ZafRawCode F8						= 0x42000000;
const ZafRawCode F9						= 0x43000000;
const ZafRawCode F10					= 0x44000000;
const ZafRawCode F11					= 0x57000000;
const ZafRawCode F12					= 0x58000000;

const ZafRawCode SHIFT_F1				= 0x3B000003;
const ZafRawCode SHIFT_F2				= 0x3C000003;
const ZafRawCode SHIFT_F3				= 0x3D000003;
const ZafRawCode SHIFT_F4				= 0x3E000003;
const ZafRawCode SHIFT_F5				= 0x3F000003;
const ZafRawCode SHIFT_F6				= 0x40000003;
const ZafRawCode SHIFT_F7				= 0x41000003;
const ZafRawCode SHIFT_F8				= 0x42000003;
const ZafRawCode SHIFT_F9				= 0x43000003;
const ZafRawCode SHIFT_F10				= 0x44000003;
const ZafRawCode SHIFT_F11				= 0x57000003;
const ZafRawCode SHIFT_F12				= 0x58000003;

const ZafRawCode CTRL_F1				= 0x3B000004;
const ZafRawCode CTRL_F2				= 0x3C000004;
const ZafRawCode CTRL_F3				= 0x3D000004;
const ZafRawCode CTRL_F4				= 0x3E000004;
const ZafRawCode CTRL_F5				= 0x3F000004;
const ZafRawCode CTRL_F6				= 0x40000004;
const ZafRawCode CTRL_F7				= 0x41000004;
const ZafRawCode CTRL_F8				= 0x42000004;
const ZafRawCode CTRL_F9				= 0x43000004;
const ZafRawCode CTRL_F10				= 0x44000004;
const ZafRawCode CTRL_F11				= 0x57000004;
const ZafRawCode CTRL_F12				= 0x58000004;

const ZafRawCode ALT_F1					= 0x3B000008;
const ZafRawCode ALT_F2					= 0x3C000008;
const ZafRawCode ALT_F3					= 0x3D000008;
const ZafRawCode ALT_F4					= 0x3E000008;
const ZafRawCode ALT_F5					= 0x3F000008;
const ZafRawCode ALT_F6					= 0x40000008;
const ZafRawCode ALT_F7					= 0x41000008;
const ZafRawCode ALT_F8					= 0x42000008;
const ZafRawCode ALT_F9					= 0x43000008;
const ZafRawCode ALT_F10				= 0x44000008;
const ZafRawCode ALT_F11				= 0x57000008;
const ZafRawCode ALT_F12				= 0x58000008;
#endif

// --------------------------------------------------------------------------
// ----- ZAF_X11 ------------------------------------------------------------
// --------------------------------------------------------------------------

#if defined (ZAF_X11)
#define XK_MISCELLANY
#include <X11/keysym.h>
const ZafRawCode ESCAPE					= XK_Escape;	// Miscellaneous keys
const ZafRawCode ENTER					= XK_Return;
const ZafRawCode SPACE					= XK_space;
const ZafRawCode BACKSPACE				= XK_BackSpace;
const ZafRawCode TAB					= XK_Tab;

const ZafRawCode GRAY_ENTER				= XK_KP_Enter;	// Gray keys
const ZafRawCode GRAY_UP_ARROW			= XK_Up;
const ZafRawCode GRAY_DOWN_ARROW		= XK_Down;
const ZafRawCode GRAY_LEFT_ARROW		= XK_Left;
const ZafRawCode GRAY_RIGHT_ARROW		= XK_Right;
const ZafRawCode GRAY_INSERT			= XK_Insert;
const ZafRawCode GRAY_DELETE			= XK_Delete;
const ZafRawCode GRAY_HOME				= XK_Home;
const ZafRawCode GRAY_END				= XK_End;
const ZafRawCode GRAY_PGUP				= XK_Prior;
const ZafRawCode GRAY_PGDN				= XK_Next;
const ZafRawCode GRAY_DIVIDE			= XK_KP_Divide;
const ZafRawCode GRAY_MULTIPLY			= XK_KP_Multiply;
const ZafRawCode GRAY_PLUS				= XK_KP_Add;
const ZafRawCode GRAY_MINUS				= XK_KP_Subtract;

const ZafRawCode WHITE_UP_ARROW			= 0xFF97;	// White keys
const ZafRawCode WHITE_DOWN_ARROW		= 0xFF99;
const ZafRawCode WHITE_LEFT_ARROW		= 0xFF96;
const ZafRawCode WHITE_RIGHT_ARROW		= 0xFF98;
const ZafRawCode WHITE_INSERT			= 0xFF9E;
const ZafRawCode WHITE_DELETE			= 0xFF9F;
const ZafRawCode WHITE_HOME				= 0xFF95;
const ZafRawCode WHITE_END				= 0xFF9C;
const ZafRawCode WHITE_PGUP				= 0xFF9A;
const ZafRawCode WHITE_PGDN				= 0xFF9B;
const ZafRawCode WHITE_CENTER			= 0xFF9D;

const ZafRawCode F1						= XK_F1;	// Function keys
const ZafRawCode F2						= XK_F2;
const ZafRawCode F3						= XK_F3;
const ZafRawCode F4						= XK_F4;
const ZafRawCode F5						= XK_F5;
const ZafRawCode F6						= XK_F6;
const ZafRawCode F7						= XK_F7;
const ZafRawCode F8						= XK_F8;
const ZafRawCode F9						= XK_F9;
const ZafRawCode F10					= XK_F10;
const ZafRawCode F11					= XK_F11;
const ZafRawCode F12					= XK_F12;
#endif

// --------------------------------------------------------------------------
// ----- ZAF_CURSES ---------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZAF_CURSES)
const ZafRawCode ESCAPE					= 0x1B;	
const ZafRawCode ENTER					= 0x0D;     
const ZafRawCode SPACE					= 0x20;
const ZafRawCode TAB					= 0x09;

const ZafRawCode BACKSPACE				= KEY_BACKSPACE;
//const ZafRawCode CTRL_BACKSPACE		= 0x0E7F;
//const ZafRawCode CTRL_TAB				= 0x9400;
const ZafRawCode BACKTAB				= KEY_BTAB;

const ZafRawCode CTRL_BREAK				= KEY_BREAK;

const ZafRawCode UP_ARROW				= KEY_UP;
const ZafRawCode DOWN_ARROW				= KEY_DOWN;
const ZafRawCode LEFT_ARROW				= KEY_LEFT;
const ZafRawCode RIGHT_ARROW			= KEY_RIGHT;
const ZafRawCode INSERT					= KEY_IC;
const ZafRawCode DELETE					= KEY_DC;
const ZafRawCode HOME					= KEY_HOME;
#if defined(SCO_UNIX)
const ZafRawCode END					= KEY_END;
#endif
const ZafRawCode PGUP					= KEY_PPAGE;
const ZafRawCode PGDN					= KEY_NPAGE;
const ZafRawCode DIVIDE					= '/';
const ZafRawCode MULTIPLY				= '*';
const ZafRawCode PLUS					= '+';
const ZafRawCode MINUS					= '-';

const ZafRawCode WHITE_END				= KEY_C1;
const ZafRawCode WHITE_PGUP				= KEY_A3;
const ZafRawCode WHITE_PGDN				= KEY_C3;
const ZafRawCode WHITE_CENTER			= KEY_B2;

const ZafRawCode F1						= KEY_F(1);	// Function keys
const ZafRawCode F2						= KEY_F(2);
const ZafRawCode F3						= KEY_F(3);
const ZafRawCode F4						= KEY_F(4);
const ZafRawCode F5						= KEY_F(5);
const ZafRawCode F6						= KEY_F(6);
const ZafRawCode F7						= KEY_F(7);
const ZafRawCode F8						= KEY_F(8);
const ZafRawCode F9						= KEY_F(9);
const ZafRawCode F10					= KEY_F(10);
const ZafRawCode F11					= KEY_F(11);
const ZafRawCode F12					= KEY_F(12);

#if defined(ZAF_PC_KEYBRD)
const ZafRawCode ALT_KEY				= '`';
const ZafRawCode CTRL_KEY				= '~';
#else
const ZafRawCode ALT_KEY				= 0x1B;
#endif

const ZafRawCode CTRL_A					= 0x01;	// down-action scan codes
const ZafRawCode CTRL_B					= 0x02;
const ZafRawCode CTRL_C					= 0x03;
const ZafRawCode CTRL_D					= 0x04;
const ZafRawCode CTRL_E					= 0x05;
const ZafRawCode CTRL_F					= 0x06;
const ZafRawCode CTRL_G					= 0x07;
const ZafRawCode CTRL_H					= 0x08;
const ZafRawCode CTRL_I					= 0x09;
const ZafRawCode CTRL_J					= 0x0A;
const ZafRawCode CTRL_K					= 0x0B;
const ZafRawCode CTRL_L					= 0x0C;
const ZafRawCode CTRL_M					= 0x0D;
const ZafRawCode CTRL_N					= 0x0E;
const ZafRawCode CTRL_O					= 0x0F;
const ZafRawCode CTRL_P					= 0x10;
const ZafRawCode CTRL_Q					= 0x11;
const ZafRawCode CTRL_R					= 0x12;
const ZafRawCode CTRL_S					= 0x13;
const ZafRawCode CTRL_T					= 0x14;
const ZafRawCode CTRL_U					= 0x15;
const ZafRawCode CTRL_V					= 0x16;
const ZafRawCode CTRL_W					= 0x17;
const ZafRawCode CTRL_X					= 0x18;
const ZafRawCode CTRL_Y					= 0x19;
const ZafRawCode CTRL_Z					= 0x1A;
#endif

// --------------------------------------------------------------------------
// ----- ZAF_MACINTOSH ------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZAF_MACINTOSH)
const ZafRawCode ESCAPE					= 0x3500;			// Miscellaneous keys
const ZafRawCode ENTER					= 0x2400;
const ZafRawCode SPACE					= 0x3100;
const ZafRawCode BACKSPACE				= 0x3300;
const ZafRawCode TAB					= 0x3000;

const ZafRawCode GRAY_ENTER				= 0x4C00;			// Gray keys
const ZafRawCode GRAY_UP_ARROW			= 0x7E00;
const ZafRawCode GRAY_DOWN_ARROW		= 0x7D00;
const ZafRawCode GRAY_LEFT_ARROW		= 0x7B00;
const ZafRawCode GRAY_RIGHT_ARROW		= 0x7C00;
const ZafRawCode GRAY_HELP				= 0x7200;
const ZafRawCode GRAY_INSERT			= GRAY_HELP;
const ZafRawCode GRAY_DELETE			= 0x7500;
const ZafRawCode GRAY_HOME				= 0x7300;
const ZafRawCode GRAY_END				= 0x7700;
const ZafRawCode GRAY_PGUP				= 0x7400;
const ZafRawCode GRAY_PGDN				= 0x7900;
const ZafRawCode GRAY_DIVIDE			= 0x4B00;
const ZafRawCode GRAY_MULTIPLY			= 0x4300;
const ZafRawCode GRAY_PLUS				= 0x4500;
const ZafRawCode GRAY_MINUS				= 0x4E00;

const ZafRawCode WHITE_UP_ARROW			= GRAY_UP_ARROW;	// White keys
const ZafRawCode WHITE_DOWN_ARROW		= GRAY_DOWN_ARROW;
const ZafRawCode WHITE_LEFT_ARROW		= GRAY_LEFT_ARROW;
const ZafRawCode WHITE_RIGHT_ARROW		= GRAY_RIGHT_ARROW;
const ZafRawCode WHITE_HELP				= GRAY_HELP;
const ZafRawCode WHITE_INSERT			= GRAY_INSERT;
const ZafRawCode WHITE_DELETE			= GRAY_DELETE;
const ZafRawCode WHITE_HOME				= GRAY_HOME;
const ZafRawCode WHITE_END				= GRAY_END;
const ZafRawCode WHITE_PGUP				= GRAY_PGUP;
const ZafRawCode WHITE_PGDN				= GRAY_PGDN;

const ZafRawCode WHITE_C				= 0x0800;
const ZafRawCode WHITE_Q				= 0x0C00;
const ZafRawCode WHITE_V				= 0x0900;
const ZafRawCode WHITE_W				= 0x0D00;
const ZafRawCode WHITE_X				= 0x0700;
const ZafRawCode WHITE_QUESTION			= 0x2C00;

const ZafRawCode F1						= 0x7A00;			// Function keys
const ZafRawCode F2						= 0x7800;
const ZafRawCode F3						= 0x6300;
const ZafRawCode F4						= 0x7600;
const ZafRawCode F5						= 0x6000;
const ZafRawCode F6						= 0x6100;
const ZafRawCode F7						= 0x6200;
const ZafRawCode F8						= 0x6400;
const ZafRawCode F9						= 0x6500;
const ZafRawCode F10					= 0x6D00;
const ZafRawCode F11					= 0x6700;
const ZafRawCode F12					= 0x6F00;
const ZafRawCode F13					= 0x6900;
const ZafRawCode F14					= 0x6B00;
const ZafRawCode F15					= 0x7100;
#endif

#endif

